/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.statements;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public enum HelperMethod {
    TO_STRING_CONVERSION("convertToString", String.class, Object.class),
    TO_BOOLEAN_CONVERSION("convertToBoolean", Boolean.TYPE, Object.class),
    EMPTINESS_CHECK("isEmpty", Boolean.TYPE, Object.class),
    EQUALS_CHECK("isEqual", Boolean.TYPE, Object.class, Object.class),
    SHOULD_RENDER_ATTRIBUTE("shouldRenderAttribute", Boolean.TYPE, Object.class),
    CREATE_ATTRIBUTES("attributes", "Attributes", new Class[0]),
    RENDER_ATTRIBUTES_SET("renderPassThroughAttributes", Void.TYPE, FacesContext.class, UIComponent.class, Collection.class),
    RENDER_ATTRIBUTE("renderAttribute", Void.TYPE, FacesContext.class, String.class, Object.class);

    public static final EnumMap<HelperMethod, String> METHOD_NAMES;
    private static final Set<HelperMethod> CONVERSION_METHODS;
    private final String name;
    private final String returnType;
    private final Class<?>[] argumentTypes;

    private HelperMethod(String name, String returnType, Class<?> ... argumentTypes) {
        this.name = name;
        this.returnType = returnType;
        this.argumentTypes = argumentTypes;
    }

    private HelperMethod(String name, Class<?> returnType, Class<?> ... argumentTypes) {
        this(name, returnType.getName(), argumentTypes);
    }

    public String getName() {
        return this.name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public Class<?>[] getArgumentTypes() {
        return this.argumentTypes;
    }

    public static Set<HelperMethod> getConversionMethods() {
        return CONVERSION_METHODS;
    }

    static {
        METHOD_NAMES = Maps.newEnumMap(HelperMethod.class);
        CONVERSION_METHODS = EnumSet.of(TO_STRING_CONVERSION, TO_BOOLEAN_CONVERSION);
        for (HelperMethod method : HelperMethod.values()) {
            METHOD_NAMES.put(method, method.getName());
        }
    }
}

