/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.statements;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.List;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.generate.freemarker.FreeMarkerRenderer;
import org.richfaces.cdk.templatecompiler.TemplateModel;
import org.richfaces.cdk.templatecompiler.builder.model.Argument;
import org.richfaces.cdk.templatecompiler.builder.model.JavaMethod;
import org.richfaces.cdk.templatecompiler.builder.model.JavaModifier;
import org.richfaces.cdk.templatecompiler.el.types.ELType;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;
import org.richfaces.cdk.templatecompiler.statements.FreeMarkerTemplateStatementBase;
import org.richfaces.cdk.templatecompiler.statements.HelperMethod;
import org.richfaces.cdk.templatecompiler.statements.HelperMethodFactory;
import org.richfaces.cdk.templatecompiler.statements.RendererUtilsMethod;

public class HelperMethodFactoryImpl
implements HelperMethodFactory {
    private TypesFactory typesFactory;
    @Inject(optional=true)
    @Named(value="rendererUtils")
    private String rendererUtilsClass = "org.richfaces.renderkit.RenderKitUtils";
    private FreeMarkerRenderer renderer;
    private final EnumMap<HelperMethod, JavaMethod> helperMethods = Maps.newEnumMap(HelperMethod.class);
    private final Logger log;

    @Inject
    public HelperMethodFactoryImpl(Logger log) {
        this.log = log;
    }

    @Inject
    public void initHelperMethods(@TemplateModel FreeMarkerRenderer renderer, TypesFactory typesFactory) {
        this.renderer = renderer;
        this.typesFactory = typesFactory;
        this.buildHelperMethod(HelperMethod.EMPTINESS_CHECK, false, "emptiness-check-method", "object");
        this.buildHelperMethod(HelperMethod.EQUALS_CHECK, false, "equals-check-method", "o1", "o2");
        this.buildHelperMethod(HelperMethod.TO_BOOLEAN_CONVERSION, false, "conversion-to-boolean-method", "object");
        this.buildHelperMethod(HelperMethod.TO_STRING_CONVERSION, false, "conversion-to-string-method", "object");
        this.buildHelperMethod(HelperMethod.SHOULD_RENDER_ATTRIBUTE, true, "should-render-attribute", "attributeValue");
        this.buildHelperMethod(HelperMethod.RENDER_ATTRIBUTE, true, "render-attribute", "attributeValue").getExceptions().add(typesFactory.getType((Type)((Object)IOException.class)));
        JavaMethod renderAttributes = this.buildHelperMethod(HelperMethod.RENDER_ATTRIBUTES_SET, true, "render-attributes-set", "context", "component");
        List<Argument> arguments = renderAttributes.getArguments();
        arguments.add(new Argument("attributes", typesFactory.getType("Attributes")));
        renderAttributes.getExceptions().add(typesFactory.getType((Type)((Object)IOException.class)));
        this.buildHelperMethod(HelperMethod.CREATE_ATTRIBUTES, true, "create-attributes", new String[0]);
    }

    private JavaMethod buildHelperMethod(HelperMethod helperMethod, boolean utilsMethod, String templateName, String ... argumentNames) {
        JavaMethod helperJavaMethod;
        if (utilsMethod && !"#built-in".equals(this.rendererUtilsClass)) {
            helperJavaMethod = new RendererUtilsMethod(helperMethod, this.rendererUtilsClass);
        } else {
            Class<?>[] argumentTypes = helperMethod.getArgumentTypes();
            Argument[] arguments = new Argument[argumentNames.length];
            for (int i = 0; i < argumentNames.length; ++i) {
                arguments[i] = new Argument(argumentNames[i], this.typesFactory.getType(argumentTypes[i]));
            }
            ELType returnType = this.typesFactory.getType(helperMethod.getReturnType());
            helperJavaMethod = new JavaMethod(helperMethod.getName(), returnType, arguments);
            helperJavaMethod.addModifier(JavaModifier.PRIVATE);
            helperJavaMethod.addModifier(JavaModifier.STATIC);
            helperJavaMethod.setMethodBody(new FreeMarkerTemplateStatementBase(this.renderer, templateName));
        }
        this.helperMethods.put(helperMethod, helperJavaMethod);
        return helperJavaMethod;
    }

    @Override
    public JavaMethod getHelperMethod(HelperMethod helper) {
        return this.helperMethods.get((Object)helper);
    }
}

