/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.statements;

import com.google.inject.Inject;
import com.google.inject.internal.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import org.richfaces.cdk.attributes.Attribute;
import org.richfaces.cdk.generate.freemarker.FreeMarkerRenderer;
import org.richfaces.cdk.templatecompiler.TemplateModel;
import org.richfaces.cdk.templatecompiler.statements.FreeMarkerTemplateStatementBase;

public class WriteAttributesSetStatement
extends FreeMarkerTemplateStatementBase {
    private static final String PASS_THROUGH_ATTRIBUTES_FIELD_NAME = "PASS_THROUGH_ATTRIBUTES";
    private static AtomicInteger fieldCounter = new AtomicInteger(0);
    private String fieldName = "PASS_THROUGH_ATTRIBUTES" + fieldCounter.getAndIncrement();
    private Collection<PassThrough> attributes;

    @Inject
    public WriteAttributesSetStatement(@TemplateModel FreeMarkerRenderer renderer) {
        super(renderer, "write-attributes-set");
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setAttributes(Collection<PassThrough> passThroughAttributes) {
        this.attributes = passThroughAttributes;
    }

    public Collection<PassThrough> getAttributes() {
        return this.attributes;
    }

    public static final class PassThrough
    implements Comparable<PassThrough> {
        QName name;
        Attribute.Kind kind = Attribute.Kind.GENERIC;
        String componentAttribute;
        String type;
        Object defaultValue;
        Set<String> behaviors = Sets.newHashSet();

        public QName getName() {
            return this.name;
        }

        public Attribute.Kind getKind() {
            return this.kind;
        }

        public String getComponentAttribute() {
            return this.componentAttribute;
        }

        public String getType() {
            return this.type;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public Set<String> getBehaviors() {
            return this.behaviors;
        }

        public String getBuilderMethod() {
            if (Attribute.Kind.BOOLEAN.equals((Object)this.kind)) {
                return "bool";
            }
            return this.kind.toString().toLowerCase();
        }

        @Override
        public int compareTo(PassThrough o) {
            return this.name.toString().compareTo(o.name.toString());
        }
    }
}

