/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.xmlconfig;

import com.google.inject.Inject;
import java.io.Writer;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.CdkWriter;
import org.richfaces.cdk.FileManager;
import org.richfaces.cdk.Output;
import org.richfaces.cdk.Outputs;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.xmlconfig.JAXB;
import org.richfaces.cdk.xmlconfig.model.FacesConfigAdapter;

public class FacesConfigGenerator
implements CdkWriter {
    public static final String FACES_SCHEMA_LOCATION = "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-facesconfig_2_0.xsd";
    private static final String FACES_CONFIG_XML = "META-INF/faces-config.xml";
    @Inject
    private JAXB jaxbBinding;
    @Inject
    @Output(value=Outputs.RESOURCES)
    private FileManager outputFileManager;
    private FacesConfigAdapter libraryAdapter = new FacesConfigAdapter();

    @Override
    public void render(ComponentLibrary library) throws CdkException {
        if (!library.isEmpty()) {
            try {
                Writer facesConfigXml = this.outputFileManager.createOutput(FACES_CONFIG_XML, library.lastModified());
                if (null != facesConfigXml) {
                    this.jaxbBinding.marshal(facesConfigXml, FACES_SCHEMA_LOCATION, this.libraryAdapter.marshal(library));
                }
            }
            catch (Exception e) {
                if (e instanceof CdkException) {
                    throw (CdkException)e;
                }
                throw new CdkException(e);
            }
        }
    }

    private boolean empty(ComponentLibrary library) {
        return library.getComponents().isEmpty() && library.getBehaviors().isEmpty() && library.getConverters().isEmpty() && library.getEvents().isEmpty() && library.getFunctions().isEmpty() && library.getListeners().isEmpty() && library.getRenderKits().isEmpty() && library.getValidators().isEmpty() && library.getExtension().getExtensions().isEmpty();
    }
}

