/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.xmlconfig;

import com.google.inject.Inject;
import java.io.File;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.FileManager;
import org.richfaces.cdk.ModelBuilder;
import org.richfaces.cdk.Source;
import org.richfaces.cdk.Sources;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.xmlconfig.JAXB;
import org.richfaces.cdk.xmlconfig.model.FacesConfigAdapter;
import org.richfaces.cdk.xmlconfig.model.FacesConfigBean;

public class FacesConfigParser
implements ModelBuilder {
    private static final FacesConfigAdapter ADAPTER = new FacesConfigAdapter();
    @Inject
    private JAXB jaxbBinding;
    @Inject
    private ComponentLibrary library;
    @Inject
    @Source(value=Sources.FACES_CONFIGS)
    private FileManager configFiles;

    @Override
    public void build() throws CdkException {
        for (File file : this.configFiles.getFiles()) {
            FacesConfigBean unmarshal = this.unmarshalFacesConfig(file);
            if (null == unmarshal) continue;
            ComponentLibrary facesConfig = (ComponentLibrary)ADAPTER.unmarshal(unmarshal);
            this.library.getComponents().addAll(facesConfig.getComponents());
            this.library.getRenderKits().addAll(facesConfig.getRenderKits());
            this.library.getConverters().addAll(facesConfig.getConverters());
        }
    }

    protected FacesConfigBean unmarshalFacesConfig(File file) throws CdkException {
        return this.jaxbBinding.unmarshal(file, "http://java.sun.com/xml/ns/javaee/web-facesconfig_2_0.xsd", FacesConfigBean.class);
    }
}

