/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.xmlconfig.model;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import org.richfaces.cdk.model.AttributeModel;
import org.richfaces.cdk.model.ConfigExtension;
import org.richfaces.cdk.model.PropertyBase;
import org.richfaces.cdk.model.PropertyModel;
import org.richfaces.cdk.xmlconfig.model.ExtensibleBean;

public abstract class ElementBeanBase<E extends ConfigExtension>
extends ExtensibleBean<E> {
    private static final Predicate<PropertyBase> PROPERTY_PREDICATE = new Predicate<PropertyBase>(){

        public boolean apply(PropertyBase input) {
            return input instanceof PropertyModel;
        }
    };
    private static final Predicate<PropertyBase> ATTRIBUTE_PREDICATE = new Predicate<PropertyBase>(){

        public boolean apply(PropertyBase input) {
            return input instanceof AttributeModel;
        }
    };
    private Collection<? extends PropertyBase> attributes = Lists.newArrayList();
    private Collection<PropertyModel> properties = Collections2.filter(this.attributes, PROPERTY_PREDICATE);
    private Collection<AttributeModel> facesAttributes = Collections2.filter(this.attributes, ATTRIBUTE_PREDICATE);

    public Collection<PropertyModel> getProperties() {
        return this.properties;
    }

    public Collection<AttributeModel> getFacesAttributes() {
        return this.facesAttributes;
    }

    public Collection<PropertyBase> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<PropertyBase> attributes) {
        this.attributes = attributes;
        this.properties = Collections2.filter(this.attributes, PROPERTY_PREDICATE);
        this.facesAttributes = Collections2.filter(this.attributes, ATTRIBUTE_PREDICATE);
    }
}

