/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;

public class CdkClassLoader
extends URLClassLoader {
    private static final URL[] EMPTY_URLS = new URL[0];
    private Iterable<File> files;

    public CdkClassLoader(Iterable<File> files) throws MalformedURLException {
        super(EMPTY_URLS);
        this.addFiles(files);
    }

    public CdkClassLoader(Iterable<File> files, ClassLoader parent) throws MalformedURLException {
        super(EMPTY_URLS, parent);
        this.addFiles(files);
    }

    public CdkClassLoader(ClassLoader classLoader) {
        super(EMPTY_URLS, classLoader);
    }

    public Iterable<File> getFiles() {
        return this.files;
    }

    private void addFileNames(Iterable<String> files) throws MalformedURLException {
        HashSet filesSet = Sets.newHashSet();
        for (String name : files) {
            File file = new File(name);
            filesSet.add(file);
        }
        this.addFiles(filesSet);
    }

    private void addFiles(Iterable<File> filesSet) throws MalformedURLException {
        this.files = ImmutableSet.copyOf(filesSet);
        for (File file : filesSet) {
            URL url = file.toURI().toURL();
            this.addURL(url);
        }
    }
}

