/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk;

import com.google.inject.Inject;
import org.richfaces.cdk.Logger;

public class TimeMeasure {
    private static final String START = "[%s started]";
    private static final String START_PARAM = "[%s started: %s]";
    private static final String STOP = "[%s completed: %s ms]";
    private String name;
    private boolean info = false;
    private long start = System.currentTimeMillis();
    @Inject
    private Logger log;

    public TimeMeasure(String name, Logger log) {
        this.name = name;
        this.log = log;
    }

    public TimeMeasure start() {
        this.log(START, this.name);
        this.start = System.currentTimeMillis();
        return this;
    }

    public TimeMeasure start(String param) {
        this.log(START_PARAM, this.name, param);
        this.start = System.currentTimeMillis();
        return this;
    }

    public TimeMeasure stop() {
        long end = System.currentTimeMillis();
        this.log(STOP, this.name, end - this.start);
        return this;
    }

    public TimeMeasure info(boolean info) {
        this.info = info;
        return this;
    }

    private void log(String message, Object ... arguments) {
        if (this.info) {
            this.log.info((CharSequence)String.format(message, arguments));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)String.format(message, arguments));
        }
    }
}

