/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt;

import com.google.inject.Inject;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.ModelBuilder;
import org.richfaces.cdk.TimeMeasure;
import org.richfaces.cdk.apt.JavaSourceProcessor;
import org.richfaces.cdk.apt.LibraryCompiler;
import org.richfaces.cdk.model.ComponentLibrary;

public class DefaultLibraryCompiler
implements LibraryCompiler {
    @Inject
    private Logger log;
    @Inject
    private JavaSourceProcessor javaSourceProcessor;
    @Inject
    private Set<ModelBuilder> builders;
    @Inject
    private ComponentLibrary library;

    @Override
    public void beforeJavaSourceProcessing() {
    }

    @Override
    public void processJavaSource(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv) {
        this.javaSourceProcessor.process(processingEnv, roundEnv);
    }

    @Override
    public void afterJavaSourceProcessing() {
    }

    @Override
    public void processNonJavaSources() throws CdkException {
        for (ModelBuilder builder : this.builders) {
            try {
                TimeMeasure time = new TimeMeasure("builder", this.log).info(true).start(builder.getClass().getSimpleName());
                builder.build();
                time.stop();
            }
            catch (CdkException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void completeLibrary() throws CdkException {
    }
}

