/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt;

import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.richfaces.cdk.Logger;

final class DiagnosticListenerImplementation
implements DiagnosticListener<JavaFileObject> {
    private final Logger log;
    private Locale locale;

    DiagnosticListenerImplementation(Logger log, Locale locale) {
        this.log = log;
    }

    @Override
    public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
        Diagnostic.Kind kind;
        StringBuilder message = new StringBuilder(diagnostic.getMessage(this.locale));
        JavaFileObject source = diagnostic.getSource();
        if (null != source) {
            message.append(", in the file:").append(source.getName()).append(" at line ").append(diagnostic.getLineNumber()).append(" in column ").append(diagnostic.getColumnNumber());
        }
        if (Diagnostic.Kind.ERROR.equals((Object)(kind = diagnostic.getKind()))) {
            this.log.error((CharSequence)message);
        } else if (Diagnostic.Kind.MANDATORY_WARNING.equals((Object)kind) || Diagnostic.Kind.WARNING.equals((Object)kind)) {
            this.log.warn((CharSequence)message);
        } else if (Diagnostic.Kind.NOTE.equals((Object)kind)) {
            this.log.info((CharSequence)message);
        } else {
            this.log.debug((CharSequence)message);
        }
    }
}

