/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt;

import com.google.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.tools.Diagnostic;
import org.richfaces.cdk.CdkProcessingException;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.apt.JavaSourceTracker;
import org.richfaces.cdk.apt.processors.CdkAnnotationProcessor;
import org.richfaces.cdk.model.ComponentLibrary;

public class JavaSourceProcessor {
    @Inject
    private Logger log;
    @Inject
    private Set<CdkAnnotationProcessor> processors;
    @Inject
    private ComponentLibrary library;
    @Inject
    private JavaSourceTracker sourceCache;
    private ProcessingEnvironment processingEnv;

    public void process(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv) {
        this.processingEnv = processingEnv;
        for (CdkAnnotationProcessor processor : this.processors) {
            this.processAnnotation(processor, roundEnv);
        }
    }

    protected void processAnnotation(CdkAnnotationProcessor processor, RoundEnvironment environment) {
        Class<? extends Annotation> processedAnnotation = processor.getProcessedAnnotation();
        this.log.debug((CharSequence)("Process all elements annotated with " + processedAnnotation.getName()));
        Target target = processedAnnotation.getAnnotation(Target.class);
        Set<? extends Element> rootElements = environment.getRootElements();
        for (Element element : rootElements) {
            if (!this.sourceCache.isChanged(element)) continue;
            if (this.isAppropriateTarget(element, target)) {
                this.processElement(processor, processedAnnotation, element);
                continue;
            }
            for (Element element2 : element.getEnclosedElements()) {
                if (!this.sourceCache.isChanged(element2) || !this.isAppropriateTarget(element2, target)) continue;
                this.processElement(processor, processedAnnotation, element2);
            }
        }
    }

    private void processElement(CdkAnnotationProcessor processor, Class<? extends Annotation> processedAnnotation, Element element) {
        if (null != element.getAnnotation(processedAnnotation)) {
            try {
                this.log.debug((CharSequence)("Process " + element.getSimpleName() + " annotated with " + processedAnnotation.getName()));
                processor.process(element, this.library);
            }
            catch (CdkProcessingException e) {
                this.sendError(element, e);
            }
        }
    }

    private boolean isAppropriateTarget(Element element, Target target) {
        boolean match = false;
        ElementKind kind = element.getKind();
        if (null != target) {
            block6: for (ElementType targetType : target.value()) {
                switch (targetType) {
                    case TYPE: {
                        match |= ElementKind.CLASS.equals((Object)kind) || ElementKind.INTERFACE.equals((Object)kind) || ElementKind.ENUM.equals((Object)kind);
                        continue block6;
                    }
                    case PACKAGE: {
                        match |= ElementKind.PACKAGE.equals((Object)kind);
                        continue block6;
                    }
                    case METHOD: {
                        match |= ElementKind.METHOD.equals((Object)kind);
                        continue block6;
                    }
                    case FIELD: {
                        match |= ElementKind.FIELD.equals((Object)kind);
                        continue block6;
                    }
                }
            }
        } else {
            match = ElementKind.CLASS.equals((Object)kind) || ElementKind.INTERFACE.equals((Object)kind) || ElementKind.ENUM.equals((Object)kind) || ElementKind.PACKAGE.equals((Object)kind) || ElementKind.METHOD.equals((Object)kind) || ElementKind.FIELD.equals((Object)kind);
        }
        return match;
    }

    private void sendError(Element componentElement, Exception e) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage(), componentElement);
    }
}

