/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.tools.JavaFileObject;
import org.richfaces.cdk.apt.JavaSourceTracker;

@Singleton
public class JavaSourceTrackerImpl
implements JavaSourceTracker {
    private List<JavaFileObject> changed = Lists.newLinkedList();
    private Map<Element, Boolean> elements = Maps.newHashMap();

    @Override
    public void putChanged(JavaFileObject sourceObject) {
        this.changed.add(sourceObject);
    }

    @Override
    public boolean isChanged(Element element) {
        Boolean result = this.elements.get(element);
        if (result == null) {
            result = this.determineElementChanged(element);
            this.elements.put(element, result);
        }
        return result;
    }

    private boolean determineElementChanged(Element element) {
        ElementKind kind = element.getKind();
        if (kind == ElementKind.CLASS || kind == ElementKind.ENUM || kind == ElementKind.INTERFACE) {
            for (JavaFileObject sourceObject : this.changed) {
                if (!sourceObject.isNameCompatible(element.getSimpleName().toString(), JavaFileObject.Kind.SOURCE)) continue;
                this.elements.put(element, true);
                return true;
            }
            return false;
        }
        return true;
    }
}

