/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt.processors;

import com.google.inject.Inject;
import com.google.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import org.richfaces.cdk.apt.SourceUtils;
import org.richfaces.cdk.apt.processors.DescriptionProcessor;
import org.richfaces.cdk.model.DescriptionGroup;
import org.richfaces.cdk.util.Strings;

public class DescriptionProcessorImpl
implements DescriptionProcessor {
    private final Provider<SourceUtils> utilsProvider;

    @Inject
    public DescriptionProcessorImpl(Provider<SourceUtils> utilsProvider) {
        this.utilsProvider = utilsProvider;
    }

    @Override
    public void processDescription(DescriptionGroup model, AnnotationMirror description, String docComment) {
        if (!Strings.isEmpty(docComment)) {
            model.setDescription(docComment);
        }
        if (description != null) {
            SourceUtils utils = (SourceUtils)this.utilsProvider.get();
            this.setIcon(model, description);
            utils.setModelProperty(model, description, "displayName");
            utils.setModelProperty(model, description, "description", "value");
        }
    }

    @Override
    public void processDescription(DescriptionGroup model, AnnotationMirror description) {
        this.processDescription(model, description, null);
    }

    protected void setIcon(DescriptionGroup component, AnnotationMirror description) {
        SourceUtils utils = (SourceUtils)this.utilsProvider.get();
        if (!(null == description || utils.isDefaultValue(description, "smallIcon") && utils.isDefaultValue(description, "largeIcon"))) {
            DescriptionGroup.Icon iconValue = new DescriptionGroup.Icon();
            utils.setModelProperty(iconValue, description, "smallIcon");
            utils.setModelProperty(iconValue, description, "largeIcon");
            component.setIcon(iconValue);
        }
    }
}

