/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt.processors;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.richfaces.cdk.CdkProcessingException;
import org.richfaces.cdk.annotations.TagType;
import org.richfaces.cdk.apt.SourceUtils;
import org.richfaces.cdk.apt.processors.CdkAnnotationProcessor;
import org.richfaces.cdk.apt.processors.ProcessorBase;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.FunctionModel;

public class FunctionProcessor
extends ProcessorBase
implements CdkAnnotationProcessor {
    private static final Joiner PARAMETERS_JOINER = Joiner.on((char)',').skipNulls();
    private static final Function<VariableElement, String> PARAMETER_CONVERTER = new Function<VariableElement, String>(){

        public String apply(VariableElement var) {
            return var.asType().toString();
        }
    };

    @Override
    public Class<? extends Annotation> getProcessedAnnotation() {
        return org.richfaces.cdk.annotations.Function.class;
    }

    @Override
    public void process(Element element, ComponentLibrary library) throws CdkProcessingException {
        SourceUtils utils = this.getSourceUtils();
        switch (element.getKind()) {
            case METHOD: {
                ExecutableElement methodElement = (ExecutableElement)element;
                Set<Modifier> modifiers = methodElement.getModifiers();
                if (!modifiers.contains((Object)Modifier.PUBLIC)) {
                    throw new CdkProcessingException("Only public method can be registered as EL function " + methodElement.getSimpleName());
                }
                if (!modifiers.contains((Object)Modifier.STATIC)) {
                    throw new CdkProcessingException("Only static method can be registered as EL function " + methodElement.getSimpleName());
                }
                AnnotationMirror function = utils.getAnnotationMirror(methodElement, org.richfaces.cdk.annotations.Function.class);
                FunctionModel model = new FunctionModel();
                if (!utils.isDefaultValue(function, "name")) {
                    utils.setModelProperty(model, function, "name");
                } else {
                    model.setName(methodElement.getSimpleName().toString());
                }
                model.setType(utils.getAnnotationValue(function, "type", TagType.class));
                this.setDescription(model, function, this.getDocComment(methodElement));
                StringBuilder signature = new StringBuilder();
                signature.append(methodElement.getReturnType()).append(" ");
                signature.append(methodElement.getSimpleName()).append("(");
                PARAMETERS_JOINER.appendTo(signature, Iterables.transform(methodElement.getParameters(), PARAMETER_CONVERTER));
                signature.append(")");
                model.setSignature(signature.toString());
                Element declaringClass = methodElement.getEnclosingElement();
                if (ElementKind.CLASS.equals((Object)declaringClass.getKind())) {
                    model.setFunctionClass(ClassName.parseName(((TypeElement)declaringClass).getQualifiedName().toString()));
                }
                library.getFunctions().add(model);
                break;
            }
            case CLASS: {
                break;
            }
        }
    }
}

