/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt.processors;

import java.lang.annotation.Annotation;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.richfaces.cdk.annotations.JsfComponent;
import org.richfaces.cdk.annotations.JsfRenderer;
import org.richfaces.cdk.apt.SourceUtils;
import org.richfaces.cdk.apt.processors.CdkAnnotationProcessor;
import org.richfaces.cdk.apt.processors.ProcessorBase;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.FacesId;
import org.richfaces.cdk.model.RendererModel;

@SupportedAnnotationTypes(value={"javax.faces.component.FacesComponent", "org.richfaces.cdk.annotations.JsfRenderer"})
public class RendererProcessor
extends ProcessorBase
implements CdkAnnotationProcessor {
    private static final String COMPONENT_FAMILY = "COMPONENT_FAMILY";
    private static final String RENDERER_TYPE = "RENDERER_TYPE";

    @Override
    public void process(Element rendererElement, ComponentLibrary library) {
        SourceUtils sourceUtils = this.getSourceUtils();
        AnnotationMirror annotation = sourceUtils.getAnnotationMirror(rendererElement, JsfRenderer.class);
        RendererModel rendererModel = new RendererModel();
        TypeElement rendererTypeElement = (TypeElement)rendererElement;
        this.setClassNames(rendererTypeElement, rendererModel, annotation);
        this.setRendererType(rendererTypeElement, rendererModel, annotation);
        this.setComponentFamily(rendererTypeElement, rendererModel, annotation);
        this.setDescription(rendererModel, annotation, this.getDocComment(rendererElement));
        sourceUtils.setModelProperty(rendererModel, annotation, "templatePath", "template");
        String renderKitId = sourceUtils.getAnnotationValue(annotation, "renderKitId", String.class);
        library.addRenderer(renderKitId, rendererModel);
    }

    private void setComponentFamily(TypeElement rendererElement, RendererModel rendererModel, AnnotationMirror annotation) {
        rendererModel.setFamily(FacesId.parseId(this.getAnnotationPropertyOrConstant(rendererElement, annotation, "family", COMPONENT_FAMILY)));
    }

    private void setRendererType(TypeElement rendererElement, RendererModel rendererModel, AnnotationMirror annotation) {
        rendererModel.setId(FacesId.parseId(this.getAnnotationPropertyOrConstant(rendererElement, annotation, "type", RENDERER_TYPE)));
    }

    protected String getComponentType(TypeElement componentElement) {
        JsfComponent annotation = componentElement.getAnnotation(JsfComponent.class);
        if (annotation != null) {
            return annotation.type();
        }
        return null;
    }

    @Override
    public Class<? extends Annotation> getProcessedAnnotation() {
        return JsfRenderer.class;
    }

    protected String[] getAnnotationAttributes(TypeElement componentElement) {
        return null;
    }
}

