/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.generate.java;

import com.google.inject.Inject;
import java.io.File;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.CdkWriter;
import org.richfaces.cdk.FileManager;
import org.richfaces.cdk.Output;
import org.richfaces.cdk.Outputs;
import org.richfaces.cdk.generate.freemarker.FreeMarkerRenderer;
import org.richfaces.cdk.generate.freemarker.FreeMarkerWriter;
import org.richfaces.cdk.generate.java.LibraryModel;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.EventModel;
import org.richfaces.cdk.model.ModelCollection;

public class EventSourceInterfaceGenerator
extends FreeMarkerWriter<EventModel>
implements CdkWriter {
    @Inject
    public EventSourceInterfaceGenerator(@LibraryModel FreeMarkerRenderer configuration, @Output(value=Outputs.JAVA_CLASSES) FileManager output) {
        super(configuration, output);
    }

    @Override
    public void render(ComponentLibrary library) throws CdkException {
        ModelCollection<EventModel> models = library.getEvents();
        for (EventModel model : models) {
            if (!model.isGenerateSource()) continue;
            this.generate(library, model);
        }
    }

    @Override
    protected String getOutputFileName(EventModel c) throws CdkException {
        return c.getSourceInterface().getName().replace('.', File.separatorChar) + ".java";
    }

    @Override
    protected String getTemplateName() {
        return "sourceInterface.ftl";
    }
}

