/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.generate.java.taghandler;

import com.google.inject.Inject;
import java.io.File;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.CdkWriter;
import org.richfaces.cdk.FileManager;
import org.richfaces.cdk.Output;
import org.richfaces.cdk.Outputs;
import org.richfaces.cdk.annotations.TagType;
import org.richfaces.cdk.generate.freemarker.FreeMarkerRenderer;
import org.richfaces.cdk.generate.freemarker.FreeMarkerWriter;
import org.richfaces.cdk.generate.java.LibraryModel;
import org.richfaces.cdk.generate.java.taghandler.TagWithModel;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.EventModel;
import org.richfaces.cdk.model.ModelCollection;
import org.richfaces.cdk.model.TagModel;

public class ListenerTagHandlerGenerator
extends FreeMarkerWriter<TagWithModel<EventModel>>
implements CdkWriter {
    @Inject
    public ListenerTagHandlerGenerator(@LibraryModel FreeMarkerRenderer configuration, @Output(value=Outputs.JAVA_CLASSES) FileManager output) {
        super(configuration, output);
    }

    @Override
    public void render(ComponentLibrary library) throws CdkException {
        ModelCollection<EventModel> models = library.getEvents();
        for (EventModel model : models) {
            for (TagModel tag : model.getTags()) {
                if (!TagType.All.equals((Object)tag.getType()) && !TagType.Facelets.equals((Object)tag.getType()) || !tag.isGenerate()) continue;
                this.generate(library, new TagWithModel<EventModel>(tag, model));
            }
        }
    }

    @Override
    protected String getOutputFileName(TagWithModel<EventModel> c) throws CdkException {
        return c.getTag().getTargetClass().getName().replace('.', File.separatorChar) + ".java";
    }

    @Override
    protected String getTemplateName() {
        return "listenerTagHandler.ftl";
    }
}

