/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.generate.taglib;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.CdkWriter;
import org.richfaces.cdk.FileManager;
import org.richfaces.cdk.Output;
import org.richfaces.cdk.Outputs;
import org.richfaces.cdk.generate.taglib.TaglibGeneratorVisitor;
import org.richfaces.cdk.model.ComponentLibrary;

public class TaglibWriter
implements CdkWriter {
    @Inject
    @Output(value=Outputs.RESOURCES)
    private FileManager output;

    @Override
    public void render(ComponentLibrary library) throws CdkException {
        TaglibGeneratorVisitor visitor = new TaglibGeneratorVisitor();
        library.accept(visitor, library);
        if (!visitor.isEmpty()) {
            Document document = visitor.getDocument();
            try {
                OutputFormat format1 = OutputFormat.createPrettyPrint();
                format1.setIndentSize(4);
                XMLWriter writer = new XMLWriter(this.getOutput(library), format1);
                writer.write(document);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected Writer getOutput(ComponentLibrary library) throws CdkException {
        try {
            return this.output.createOutput("META-INF/" + library.getTaglib().getShortName() + ".taglib.xml", library.lastModified());
        }
        catch (IOException e) {
            throw new CdkException((Throwable)e);
        }
    }

    public void setOutput(FileManager output) {
        this.output = output;
    }
}

