/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.model;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import org.richfaces.cdk.util.Strings;

public class ClassName
implements Serializable,
Comparable<ClassName> {
    private static final long serialVersionUID = -846623207703750456L;
    private static final ImmutableMap<String, String> PRIMITIVE_TYPES = ImmutableMap.builder().put((Object)Boolean.TYPE.getName(), (Object)Boolean.class.getName()).put((Object)Byte.TYPE.getName(), (Object)Byte.class.getName()).put((Object)Character.TYPE.getName(), (Object)Character.class.getName()).put((Object)Short.TYPE.getName(), (Object)Short.class.getName()).put((Object)Integer.TYPE.getName(), (Object)Integer.class.getName()).put((Object)Long.TYPE.getName(), (Object)Long.class.getName()).put((Object)Float.TYPE.getName(), (Object)Float.class.getName()).put((Object)Double.TYPE.getName(), (Object)Double.class.getName()).build();
    private static final ImmutableMap<String, String> DEFAULT_VALUES = ImmutableMap.builder().put((Object)Boolean.TYPE.getName(), (Object)"Boolean.FALSE").put((Object)Byte.TYPE.getName(), (Object)"Byte.MIN_VALUE").put((Object)Character.TYPE.getName(), (Object)"Character.MIN_VALUE").put((Object)Short.TYPE.getName(), (Object)"Short.MIN_VALUE").put((Object)Integer.TYPE.getName(), (Object)"Integer.MIN_VALUE").put((Object)Long.TYPE.getName(), (Object)"Long.MIN_VALUE").put((Object)Float.TYPE.getName(), (Object)"Float.MIN_VALUE").put((Object)Double.TYPE.getName(), (Object)"Double.MIN_VALUE").build();
    private final String boxingClassName;
    private final String fullName;
    private final String name;
    private final boolean primitive;
    private String typeParameters;

    public ClassName(Class<?> cl) {
        this(cl.getName().replace('$', '.'));
    }

    public ClassName(String name) {
        this.fullName = name;
        if (PRIMITIVE_TYPES.containsKey((Object)name)) {
            this.name = name;
            this.boxingClassName = (String)PRIMITIVE_TYPES.get((Object)name);
            this.primitive = true;
        } else {
            int i = name.indexOf(60);
            if (i > 0) {
                int closeBracket = name.lastIndexOf(62);
                if (closeBracket < 0 || closeBracket == name.length() - 1) {
                    this.name = name.substring(0, i);
                    this.typeParameters = name.substring(i);
                } else {
                    this.name = name.substring(0, i) + name.substring(closeBracket + 1);
                    this.typeParameters = name.substring(i, closeBracket + 1);
                }
            } else {
                this.name = name;
            }
            this.boxingClassName = name;
            this.primitive = false;
        }
    }

    public static ClassName parseName(String name) {
        return Strings.isEmpty(name) ? null : new ClassName(name);
    }

    public static ClassName get(String name) {
        if (name == null) {
            return null;
        }
        return new ClassName(name);
    }

    public static ClassName get(Class name) {
        if (name == null) {
            return null;
        }
        return new ClassName(name);
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getTypeParameters() {
        return this.typeParameters;
    }

    public void setTypeParameters(String typeParameters) {
        this.typeParameters = typeParameters;
    }

    public String getName() {
        return this.name;
    }

    public String getPackage() {
        int indexOfPeriod = this.name.lastIndexOf(46);
        if (indexOfPeriod > 0) {
            return this.name.substring(0, indexOfPeriod);
        }
        return null;
    }

    public String getSimpleName() {
        int indexOfPeriod = this.name.lastIndexOf(46);
        if (indexOfPeriod > 0) {
            return this.fullName.substring(indexOfPeriod + 1);
        }
        return this.fullName;
    }

    public String getSimpleBoxingName() {
        if (this.isPrimitive()) {
            int indexOfPeriod = this.boxingClassName.lastIndexOf(46);
            if (indexOfPeriod > 0) {
                return this.boxingClassName.substring(indexOfPeriod + 1);
            }
            return this.boxingClassName;
        }
        return this.getSimpleName();
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public String getDefaultValue() {
        return (String)DEFAULT_VALUES.get((Object)this.name);
    }

    public String getBoxingName() {
        return this.boxingClassName;
    }

    public String getGetterPrefix() {
        return this.primitive && Boolean.class.getName().equals(this.boxingClassName) ? "is" : "get";
    }

    public String toString() {
        return this.fullName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassName)) {
            return false;
        }
        ClassName other = (ClassName)obj;
        return !(this.fullName == null ? other.fullName != null : !this.fullName.equals(other.fullName));
    }

    @Override
    public int compareTo(ClassName o) {
        return this.getName().compareTo(o.getName());
    }
}

