/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.model;

import java.util.regex.Pattern;
import org.richfaces.cdk.model.InvalidNameException;

public class Name {
    private static final Pattern NAME_PATTERN = Pattern.compile("^(?:(.+)\\.)?(?:(" + (Object)((Object)Classifier.component) + "|" + (Object)((Object)Classifier.renderkit) + "|" + (Object)((Object)Classifier.event) + "|" + (Object)((Object)Classifier.taglib) + ")\\.(?:([^\\.]+)\\.)?)?([^\\.]+)$");
    private Classifier classifier;
    private String markup;
    private String prefix;
    private String simpleName;

    public static Name create(String name) throws InvalidNameException {
        Name cdkName = new Name();
        StringBuilder prefix = new StringBuilder(name.length());
        String[] parts = name.split("\\.");
        cdkName.setSimpleName(parts[parts.length - 1]);
        if (parts.length > 1) {
            try {
                cdkName.setClassifier(Classifier.valueOf(parts[parts.length - 2]));
                Name.fillPrefix(prefix, parts, parts.length - 2);
            }
            catch (IllegalArgumentException e) {
                if (parts.length > 2) {
                    try {
                        cdkName.setClassifier(Classifier.valueOf(parts[parts.length - 3]));
                        Name.fillPrefix(prefix, parts, parts.length - 3);
                        cdkName.setMarkup(parts[parts.length - 2]);
                    }
                    catch (IllegalArgumentException e1) {
                        Name.fillPrefix(prefix, parts, parts.length - 1);
                    }
                }
                prefix.append(parts[0]);
            }
            if (prefix.length() > 0) {
                cdkName.setPrefix(prefix.toString());
            }
        }
        return cdkName;
    }

    private static void fillPrefix(StringBuilder prefix, String[] parts, int size) {
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                prefix.append('.');
            }
            prefix.append(parts[i]);
        }
    }

    public static Name create(String prefix, String name) throws InvalidNameException {
        Name cdkName = Name.create(name);
        if (prefix.equals(cdkName.getPrefix())) {
            return new Name();
        }
        throw new InvalidNameException("Nape " + name + " does not start with prefix " + prefix);
    }

    public static Name create(String prefix, Classifier classifier, String name) throws InvalidNameException {
        return new Name();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Classifier getClassifier() {
        return this.classifier;
    }

    public void setClassifier(Classifier classifier) {
        this.classifier = classifier;
    }

    public String getMarkup() {
        return this.markup;
    }

    public void setMarkup(String markup) {
        this.markup = markup;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (null != this.prefix) {
            result.append(this.prefix).append('.');
        }
        if (null != this.classifier) {
            result.append((Object)this.classifier).append('.');
        }
        if (null != this.markup) {
            result.append(this.markup).append('.');
        }
        result.append(this.simpleName);
        return result.toString();
    }

    public static enum Classifier {
        component,
        renderkit,
        event,
        taglib,
        behavior;

    }
}

