/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.richfaces.cdk.templatecompiler.builder.model.Argument;
import org.richfaces.cdk.templatecompiler.el.types.ELType;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;
import org.richfaces.cdk.templatecompiler.model.CdkFragmentElement;
import org.richfaces.cdk.templatecompiler.model.CompositeAttribute;
import org.richfaces.cdk.templatecompiler.model.CompositeFragmentInterface;

public class Fragment {
    private String methodName;
    private Map<String, Argument> arguments = Maps.newLinkedHashMap();

    public Fragment(CdkFragmentElement fragmentElement, TypesFactory typesFactory) {
        List<CompositeAttribute> attributes;
        this.methodName = fragmentElement.getName();
        CompositeFragmentInterface interfaze = fragmentElement.getFragmentInterface();
        List<CompositeAttribute> list = attributes = interfaze != null ? interfaze.getAttributes() : null;
        if (attributes != null) {
            for (CompositeAttribute attribute : attributes) {
                String name = attribute.getName();
                String typeName = attribute.getType();
                boolean required = attribute.isRequired();
                String defaultValue = attribute.getDefault();
                ELType type = this.getType(name, typeName, typesFactory);
                Argument argument = new Argument(name, type);
                argument.setDefault(defaultValue);
                argument.setRequired(required);
                this.arguments.put(name, argument);
            }
        }
    }

    private ELType getType(String attributeName, String typeName, TypesFactory typesFactory) {
        try {
            return typesFactory.getType(typeName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot determine type for attribute '" + attributeName + "' of type '" + typeName + "'");
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Argument getArgumentByName(String argumentName) {
        return this.arguments.get(argumentName);
    }

    public Collection<Argument> getAllArguments() {
        return Collections.unmodifiableCollection(this.arguments.values());
    }
}

