/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.richfaces.cdk.Cache;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.FileManager;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.ModelBuilder;
import org.richfaces.cdk.Source;
import org.richfaces.cdk.Sources;
import org.richfaces.cdk.apt.CacheType;
import org.richfaces.cdk.apt.LibraryCache;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.EventName;
import org.richfaces.cdk.model.FacesId;
import org.richfaces.cdk.model.MethodSignature;
import org.richfaces.cdk.model.PropertyBase;
import org.richfaces.cdk.model.PropertyModel;
import org.richfaces.cdk.model.RenderKitModel;
import org.richfaces.cdk.model.RendererModel;
import org.richfaces.cdk.model.SimpleVisitor;
import org.richfaces.cdk.templatecompiler.AlreadyProcessedException;
import org.richfaces.cdk.templatecompiler.model.Attribute;
import org.richfaces.cdk.templatecompiler.model.ClientBehavior;
import org.richfaces.cdk.templatecompiler.model.CompositeInterface;
import org.richfaces.cdk.templatecompiler.model.ImportAttributes;
import org.richfaces.cdk.templatecompiler.model.Template;
import org.richfaces.cdk.util.Strings;
import org.richfaces.cdk.xmlconfig.FragmentParser;
import org.richfaces.cdk.xmlconfig.JAXB;

public class RendererTemplateParser
implements ModelBuilder {
    private static final Pattern PARAMETERS_STRING_PATTERN = Pattern.compile("^(\\S+)\\s+(\\S+)\\s*\\(([^\\)]*)\\)$", 4);
    private static final Pattern COMMA_SEPARATED_PATTERN = Pattern.compile("\\s*,\\s*", 4);
    private ComponentLibrary library;
    private JAXB jaxbBinding;
    private Logger log;
    private FileManager sources;
    private FragmentParser fragmentParser;
    @Inject
    @Cache(value=CacheType.NON_JAVA_SOURCES)
    public LibraryCache nonJavaCache;

    @Inject
    public RendererTemplateParser(ComponentLibrary library, JAXB jaxbBinding, Logger log, @Source(value=Sources.RENDERER_TEMPLATES) FileManager sources, FragmentParser fragmentParser) {
        this.library = library;
        this.jaxbBinding = jaxbBinding;
        this.log = log;
        this.sources = sources;
        this.fragmentParser = fragmentParser;
    }

    @Override
    public void build() throws CdkException {
        Iterable<File> sourceFiles = this.sources.getFiles();
        for (File file : sourceFiles) {
            if (!this.nonJavaCache.storedBefore(file.lastModified())) continue;
            this.build(file);
        }
    }

    public void build(final File file) throws CdkException {
        this.log.debug((CharSequence)"RendererTemplateParser.build");
        String absolutePath = file.getAbsolutePath();
        this.log.debug((CharSequence)("  - file = " + absolutePath));
        try {
            RendererModel existedModel = this.library.accept(new SimpleVisitor<RendererModel, String>(){

                @Override
                public RendererModel visitRender(RendererModel model, String absolutePath) {
                    Template template = model.getTemplate();
                    if (null != template) {
                        if (absolutePath.equals(template.getTemplatePath())) {
                            throw new AlreadyProcessedException();
                        }
                    } else if (null != model.getTemplatePath()) {
                        try {
                            if (file.equals(RendererTemplateParser.this.sources.getFile(model.getTemplatePath()))) {
                                return model;
                            }
                        }
                        catch (FileNotFoundException e) {
                            throw new CdkException("Template file defined in Renderer not found: " + model.getTemplatePath(), (Throwable)e);
                        }
                    }
                    return null;
                }
            }, absolutePath);
            Template template = this.parseTemplate(file);
            this.mergeTemplateIntoModel(template, existedModel);
        }
        catch (AlreadyProcessedException e) {
            this.log.warn((CharSequence)("Template " + absolutePath + "was already processed"));
        }
    }

    protected RendererModel mergeTemplateIntoModel(Template template, RendererModel renderer) throws CdkException {
        CompositeInterface compositeInterface = template.getInterface();
        if (renderer == null) {
            renderer = new RendererModel();
            RenderKitModel renderKit = this.library.addRenderKit(compositeInterface.getRenderKitId());
            renderKit.getRenderers().add(renderer);
        }
        renderer.setTemplate(template);
        this.setRendererType(compositeInterface, renderer);
        this.setFamily(compositeInterface, renderer);
        this.setRendererClass(compositeInterface, renderer);
        this.setRendererBaseClass(compositeInterface, renderer);
        Boolean rendersChildren = compositeInterface.getRendersChildren();
        if (rendersChildren != null) {
            renderer.setRendersChildren(rendersChildren);
        }
        List<ImportAttributes> attributesImports = compositeInterface.getAttributesImports();
        for (ImportAttributes attributesImport : attributesImports) {
            String importURI = attributesImport.getSource();
            try {
                Collection<PropertyBase> properties = this.fragmentParser.parseProperties(importURI);
                if (properties == null) continue;
                renderer.getAttributes().addAll(properties);
            }
            catch (FileNotFoundException e) {
                throw new CdkException("File for import not found", (Throwable)e);
            }
        }
        List<Attribute> templateAttributes = compositeInterface.getAttributes();
        for (Attribute templateAttribute : templateAttributes) {
            renderer.getAttributes().add(this.buildProperty(templateAttribute));
        }
        return renderer;
    }

    private PropertyModel buildProperty(Attribute templateAttribute) {
        PropertyModel rendererProperty = new PropertyModel();
        rendererProperty.setName(templateAttribute.getName());
        rendererProperty.setDefaultValue(templateAttribute.getDefaultValue());
        rendererProperty.setDescription(templateAttribute.getShortDescription());
        rendererProperty.setDisplayName(templateAttribute.getDisplayName());
        Set<EventName> eventNamesSet = this.convertBehaviorsToEvents(templateAttribute.getClientBehaviors());
        rendererProperty.getEventNames().addAll(eventNamesSet);
        Boolean required = templateAttribute.getRequired();
        if (null != required) {
            rendererProperty.setRequired(required);
        }
        MethodSignature parsedSignature = this.parseSignature(templateAttribute.getMethodSignature());
        rendererProperty.setSignature(parsedSignature);
        rendererProperty.setType(templateAttribute.getType());
        return rendererProperty;
    }

    private Set<EventName> convertBehaviorsToEvents(Collection<ClientBehavior> clientBehaviors) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (ClientBehavior clientBehavior : clientBehaviors) {
            EventName eventName = new EventName();
            eventName.setName(clientBehavior.getEvent());
            eventName.setDefaultEvent(clientBehavior.isDefaultEvent());
            result.add(eventName);
        }
        return result;
    }

    private MethodSignature parseSignature(String signatureString) {
        ArrayList parameters = Lists.newArrayList();
        MethodSignature signature = null;
        if (!Strings.isEmpty(signatureString)) {
            Matcher parametersStringMatcher = PARAMETERS_STRING_PATTERN.matcher(signatureString);
            if (!parametersStringMatcher.find()) {
                throw new IllegalArgumentException(MessageFormat.format("Signature string {0} cannot be parsed!", signatureString));
            }
            signature = new MethodSignature();
            signature.setReturnType(ClassName.parseName(parametersStringMatcher.group(1)));
            String parametersString = parametersStringMatcher.group(3);
            if (parametersString.trim().length() != 0) {
                String[] parameterStrings;
                for (String parameter : parameterStrings = COMMA_SEPARATED_PATTERN.split(parametersString)) {
                    String trimmedParameter = parameter.trim();
                    parameters.add(ClassName.parseName(trimmedParameter));
                }
                signature.setParameters(parameters);
            }
        }
        return signature;
    }

    private void setRendererClass(CompositeInterface compositeInterface, RendererModel renderer) {
        ClassName javaClass = compositeInterface.getJavaClass();
        if (null != javaClass) {
            renderer.setRendererClass(javaClass);
        }
    }

    private void setRendererBaseClass(CompositeInterface compositeInterface, RendererModel renderer) {
        ClassName baseClass = compositeInterface.getBaseClass();
        if (null != baseClass) {
            renderer.setBaseClass(baseClass);
        }
    }

    private void setFamily(CompositeInterface compositeInterface, RendererModel renderer) {
        FacesId componentFamily = compositeInterface.getComponentFamily();
        if (null != componentFamily) {
            renderer.setFamily(componentFamily);
        }
    }

    private void setRendererType(CompositeInterface compositeInterface, RendererModel renderer) {
        FacesId rendererType = compositeInterface.getRendererType();
        if (null != rendererType) {
            renderer.setId(rendererType);
        }
    }

    protected Template parseTemplate(File file) throws CdkException {
        try {
            Template template = this.jaxbBinding.unmarshal(file, "http://jboss.org/schema/richfaces/cdk/cdk-template.xsd", Template.class);
            template.setTemplatePath(file.getAbsolutePath());
            return template;
        }
        catch (FileNotFoundException e) {
            throw new CdkException("Template file not found " + file.getAbsolutePath(), (Throwable)e);
        }
    }
}

