/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.el.node;

import java.util.ArrayList;
import org.jboss.el.parser.Node;
import org.richfaces.cdk.templatecompiler.el.ELVisitor;
import org.richfaces.cdk.templatecompiler.el.ParsingException;
import org.richfaces.cdk.templatecompiler.el.node.AbstractTreeNode;
import org.richfaces.cdk.templatecompiler.el.types.ELType;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;

public abstract class AbstractMethodTreeNode
extends AbstractTreeNode {
    private static final ELType[] EMPTY_TYPES_ARRAY = new ELType[0];

    public AbstractMethodTreeNode(Node node) {
        super(node);
    }

    protected void visitMethod(StringBuilder sb, ELVisitor visitor, String methodName) throws ParsingException {
        ELType currentExpressionType = visitor.getType();
        ArrayList<ELType> argumentTypes = new ArrayList<ELType>();
        sb.append(".");
        sb.append(methodName);
        sb.append("(");
        int childrenCount = this.getChildrenCount();
        for (int k = 0; k < childrenCount; ++k) {
            if (k != 0) {
                sb.append(",");
            }
            String childOutput = this.getChildOutput(k, visitor);
            sb.append(childOutput);
            argumentTypes.add(visitor.getType());
        }
        sb.append(")");
        ELType returnType = null;
        visitor.setExpressionType(currentExpressionType);
        try {
            returnType = visitor.getMatchingVisibleMethodReturnType(methodName, argumentTypes.toArray(EMPTY_TYPES_ARRAY));
        }
        catch (ParsingException e) {
            returnType = TypesFactory.OBJECT_TYPE;
        }
        visitor.setLiteral(false);
        visitor.setExpressionType(returnType);
    }
}

