/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.el.node;

import org.jboss.el.parser.AstFunction;
import org.jboss.el.parser.Node;
import org.richfaces.cdk.templatecompiler.el.ELVisitor;
import org.richfaces.cdk.templatecompiler.el.ParsingException;
import org.richfaces.cdk.templatecompiler.el.node.AbstractMethodTreeNode;
import org.richfaces.cdk.templatecompiler.el.types.ELType;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;
import org.richfaces.cdk.templatecompiler.statements.HelperMethod;
import org.richfaces.cdk.util.Strings;

public class AstFunctionTreeNode
extends AbstractMethodTreeNode {
    public AstFunctionTreeNode(Node node) {
        super(node);
    }

    @Override
    public void visit(StringBuilder sb, ELVisitor visitor) throws ParsingException {
        AstFunction functionNode = (AstFunction)this.getNode();
        HelperMethod helperMethod = this.findMatchingHelperMethod(functionNode);
        if (helperMethod != null) {
            this.visitHelperMethod(sb, visitor, helperMethod, functionNode);
        } else {
            this.visitObjectMethod(sb, visitor, functionNode);
        }
    }

    private void visitHelperMethod(StringBuilder sb, ELVisitor visitor, HelperMethod helperMethod, AstFunction functionNode) throws ParsingException {
        visitor.addHelperMethods(helperMethod);
        visitor.setLiteral(false);
        visitor.setExpressionType(TypesFactory.OBJECT_TYPE);
        sb.append(helperMethod.getName());
        sb.append("(");
        for (int i = 0; i < functionNode.jjtGetNumChildren(); ++i) {
            if (i != 0) {
                sb.append(",");
            }
            String childOutput = this.getChildOutput(i, visitor);
            sb.append(childOutput);
        }
        sb.append(")");
    }

    private HelperMethod findMatchingHelperMethod(AstFunction functionNode) {
        if (Strings.isEmpty(functionNode.getPrefix())) {
            for (HelperMethod helperMethod : HelperMethod.values()) {
                if (!helperMethod.getName().equals(functionNode.getLocalName())) continue;
                return helperMethod;
            }
        }
        return null;
    }

    private void visitObjectMethod(StringBuilder sb, ELVisitor visitor, AstFunction functionNode) throws ParsingException {
        String identifierName = Strings.firstNonEmpty(functionNode.getPrefix(), "this");
        sb.append(identifierName);
        ELType identifierType = visitor.getVariable(identifierName);
        visitor.setExpressionType(identifierType);
        this.visitMethod(sb, visitor, functionNode.getLocalName());
        visitor.setLiteral(false);
    }
}

