/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.el.types;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.richfaces.cdk.templatecompiler.builder.model.JavaImport;
import org.richfaces.cdk.templatecompiler.builder.model.RequireImports;
import org.richfaces.cdk.templatecompiler.el.types.ELType;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;
import org.richfaces.cdk.util.ArrayUtils;

public class ComplexType
implements ELType {
    private ELType clearComponentType;
    private ELType[] typeArguments;
    private int arrayDepth;

    public ComplexType(ELType clearComponentType, ELType[] typeArguments, int arrayDepth) {
        this.clearComponentType = clearComponentType;
        this.typeArguments = typeArguments;
        this.arrayDepth = arrayDepth;
    }

    @Override
    public Iterable<JavaImport> getRequiredImports() {
        Iterable imports = Iterables.concat((Iterable)Iterables.transform(Arrays.asList(this.typeArguments), RequireImports.IMPORTS_TRANSFORM));
        LinkedHashSet result = Sets.newLinkedHashSet((Iterable)Iterables.concat(this.clearComponentType.getRequiredImports(), (Iterable)imports));
        return result;
    }

    @Override
    public boolean isNullType() {
        return false;
    }

    @Override
    public ELType[] getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public ELType getContainerType() {
        if (this.arrayDepth != 0) {
            return new ComplexType(this.clearComponentType, this.typeArguments, this.arrayDepth - 1);
        }
        if (!ArrayUtils.isEmpty(this.typeArguments)) {
            return this.typeArguments[this.typeArguments.length - 1];
        }
        return TypesFactory.OBJECT_TYPE;
    }

    @Override
    public String getCode() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.clearComponentType.getCode());
        if (!ArrayUtils.isEmpty(this.typeArguments)) {
            sb.append("<");
            for (i = 0; i < this.typeArguments.length; ++i) {
                ELType typeArgument = this.typeArguments[i];
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(typeArgument.getCode());
            }
            sb.append(">");
        }
        for (i = 0; i < this.arrayDepth; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.arrayDepth;
        result = 31 * result + (this.clearComponentType == null ? 0 : this.clearComponentType.hashCode());
        result = 31 * result + Arrays.hashCode(this.typeArguments);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComplexType other = (ComplexType)obj;
        if (this.arrayDepth != other.arrayDepth) {
            return false;
        }
        if (this.clearComponentType == null ? other.clearComponentType != null : !this.clearComponentType.equals(other.clearComponentType)) {
            return false;
        }
        return Arrays.equals(this.typeArguments, other.typeArguments);
    }

    @Override
    public ELType getRawType() {
        return this.clearComponentType;
    }

    @Override
    public boolean isArray() {
        return this.arrayDepth != 0;
    }

    @Override
    public boolean isAssignableFrom(ELType anotherType) {
        if (this.getRawType().isAssignableFrom(anotherType.getRawType())) {
            Object[] thisTypeArguments = this.getTypeArguments();
            if (ArrayUtils.isEmpty(thisTypeArguments)) {
                return true;
            }
            Object[] anotherTypeArguments = anotherType.getTypeArguments();
            if (ArrayUtils.isEmpty(anotherTypeArguments)) {
                return true;
            }
            return Arrays.equals(thisTypeArguments, anotherTypeArguments);
        }
        return false;
    }

    @Override
    public String getRawName() {
        return this.clearComponentType.getRawName();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

