/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.statements;

import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.attributes.Attribute;
import org.richfaces.cdk.attributes.Element;
import org.richfaces.cdk.attributes.Schema;
import org.richfaces.cdk.model.EventName;
import org.richfaces.cdk.model.Named;
import org.richfaces.cdk.model.PropertyBase;
import org.richfaces.cdk.templatecompiler.model.AnyElement;
import org.richfaces.cdk.templatecompiler.model.Template;
import org.richfaces.cdk.templatecompiler.statements.PassThrough;
import org.richfaces.cdk.templatecompiler.statements.StatementsContainer;
import org.richfaces.cdk.templatecompiler.statements.WriteAttributeStatement;
import org.richfaces.cdk.templatecompiler.statements.WriteAttributesSetStatement;
import org.richfaces.cdk.util.Strings;

public class AttributesStatement
extends StatementsContainer {
    private static final Splitter PASS_THGOUGH_SPLITTER = Splitter.on((Pattern)Pattern.compile("\\s+,?\\s*"));
    private static final String WILDCARD_SUFFIX = "*";
    private final Schema attributesSchema;
    private final Provider<WriteAttributeStatement> statementProvider;
    private final Provider<WriteAttributesSetStatement> passThroughStatementProvider;
    private final Logger logger;
    private QName elementName;
    private Collection<PropertyBase> componentAttributes;

    @Inject
    public AttributesStatement(@Named(value="http://jboss.org/schema/richfaces/cdk/xhtml-el") Schema attributesSchema, Provider<WriteAttributeStatement> attributeStatementProvider, Provider<WriteAttributesSetStatement> passThroughStatementProvider, Logger logger) {
        this.attributesSchema = attributesSchema;
        this.statementProvider = attributeStatementProvider;
        this.passThroughStatementProvider = passThroughStatementProvider;
        this.logger = logger;
    }

    public void processAttributes(AnyElement element, Collection<PropertyBase> componentAttributes) {
        this.componentAttributes = componentAttributes;
        HashSet processedAttributes = Sets.newHashSet();
        TreeSet passThroughAttributes = Sets.newTreeSet();
        this.elementName = element.getName();
        this.processRegularAttributes(element, processedAttributes, passThroughAttributes);
        String passThrough = element.getPassThrough();
        this.processPassThrough(processedAttributes, passThroughAttributes, passThrough);
        String passThroughWithExclusions = element.getPassThroughWithExclusions();
        this.processPassThroughWithExclusions(processedAttributes, passThroughAttributes, passThroughWithExclusions);
        if (!passThroughAttributes.isEmpty()) {
            WriteAttributesSetStatement writeAttributesSetStatement = (WriteAttributesSetStatement)this.passThroughStatementProvider.get();
            this.addStatement(writeAttributesSetStatement);
            writeAttributesSetStatement.setAttributes(passThroughAttributes);
        }
    }

    private void processPassThroughWithExclusions(Set<String> processedAttributes, TreeSet<PassThrough> passThroughAttributes, String passThroughWithExclusions) {
        if (null != passThroughWithExclusions) {
            Map elements = this.attributesSchema.getElements();
            String elementLocalName = this.elementName.getLocalPart();
            if (Template.isDefaultNamespace(this.elementName) && elements.containsKey(elementLocalName)) {
                Element schemaElement = (Element)elements.get(elementLocalName);
                Iterable exclusions = PASS_THGOUGH_SPLITTER.split((CharSequence)passThroughWithExclusions);
                for (String exclusion : exclusions) {
                    if (exclusion.endsWith(WILDCARD_SUFFIX)) {
                        String attributePrefix = exclusion.substring(0, exclusion.length() - WILDCARD_SUFFIX.length());
                        for (Attribute schemaAttribute : schemaElement.getAttributes().values()) {
                            if (!schemaAttribute.getName().startsWith(attributePrefix)) continue;
                            processedAttributes.add(schemaAttribute.getName());
                        }
                        continue;
                    }
                    processedAttributes.add(exclusion);
                }
                Iterables.addAll(processedAttributes, (Iterable)exclusions);
                for (Attribute schemaAttribute : schemaElement.getAttributes().values()) {
                    if (processedAttributes.contains(schemaAttribute.getName())) continue;
                    passThroughAttributes.add(this.createPassThrough(schemaAttribute.getName(), schemaAttribute.getComponentAttributeName()));
                }
            }
        }
    }

    private void processPassThrough(Set<String> processedAttributes, TreeSet<PassThrough> passThroughAttributes, String passThrough) {
        if (null != passThrough) {
            Iterable split = PASS_THGOUGH_SPLITTER.split((CharSequence)passThrough);
            for (String attribute : split) {
                String componentAttributeName;
                String[] splitAttr = attribute.split(":");
                String attributeName = splitAttr[0];
                String string = componentAttributeName = splitAttr.length > 1 ? splitAttr[1] : attributeName;
                if (attributeName.endsWith(WILDCARD_SUFFIX)) {
                    this.processPassThroughWithWildcard(processedAttributes, passThroughAttributes, attributeName, componentAttributeName);
                    continue;
                }
                this.addPassThroughAttribute(processedAttributes, passThroughAttributes, attributeName, componentAttributeName);
            }
        }
    }

    private void addPassThroughAttribute(Set<String> processedAttributes, TreeSet<PassThrough> passThroughAttributes, String attributeName, String componentAttributeName) {
        if (processedAttributes.add(attributeName)) {
            passThroughAttributes.add(this.createPassThrough(attributeName, componentAttributeName));
        }
    }

    private void processPassThroughWithWildcard(Set<String> processedAttributes, TreeSet<PassThrough> passThroughAttributes, String wildcardAttributeName, String wildcardComponentAttributeName) {
        String attributePrefix = wildcardAttributeName.substring(0, wildcardAttributeName.length() - WILDCARD_SUFFIX.length());
        String componentAttributePrefix = wildcardComponentAttributeName.substring(0, wildcardComponentAttributeName.length() - WILDCARD_SUFFIX.length());
        Map elements = this.attributesSchema.getElements();
        String elementLocalName = this.elementName.getLocalPart();
        if (Template.isDefaultNamespace(this.elementName) && elements.containsKey(elementLocalName)) {
            Element schemaElement = (Element)elements.get(elementLocalName);
            for (Attribute schemaAttribute : schemaElement.getAttributes().values()) {
                String attributeName = schemaAttribute.getName();
                if (!attributeName.startsWith(attributePrefix) || processedAttributes.contains(schemaAttribute.getName())) continue;
                String componentAttributeName = componentAttributePrefix + attributeName.substring(attributePrefix.length());
                this.addPassThroughAttribute(processedAttributes, passThroughAttributes, attributeName, componentAttributeName);
            }
        }
    }

    private void processRegularAttributes(AnyElement element, Set<String> processedAttributes, TreeSet<PassThrough> passThroughAttributes) {
        for (Map.Entry<QName, Object> entry : element.getAttributes().entrySet()) {
            QName qName = entry.getKey();
            if ("http://jboss.org/schema/richfaces/cdk/core".equals(qName.getNamespaceURI())) {
                this.logger.error((CharSequence)("Unknown attribute " + qName));
                continue;
            }
            Object value = entry.getValue();
            String localAttributeName = qName.getLocalPart();
            if ("http://jboss.org/schema/richfaces/cdk/ext".equals(qName.getNamespaceURI())) {
                passThroughAttributes.add(this.createPassThrough(localAttributeName, value.toString()));
                processedAttributes.add(localAttributeName);
                continue;
            }
            if (Template.isDefaultNamespace(qName.getNamespaceURI())) {
                Attribute schemaAttribute = this.getSchemaAttribute(localAttributeName);
                this.setupAttributeStatement(qName, value, schemaAttribute);
                processedAttributes.add(localAttributeName);
                continue;
            }
            this.setupAttributeStatement(qName, value, this.getGenericAttribute(localAttributeName));
        }
    }

    private PassThrough createPassThrough(String localAttributeName, String componentAttribute) {
        PassThrough passThrough = new PassThrough();
        passThrough.name = QName.valueOf(localAttributeName);
        Attribute schemaAttribute = this.getSchemaAttribute(localAttributeName);
        passThrough.componentAttribute = Strings.isEmpty(componentAttribute) ? schemaAttribute.getComponentAttributeName() : componentAttribute;
        passThrough.kind = schemaAttribute.getKind();
        passThrough.defaultValue = schemaAttribute.getDefaultValue();
        try {
            PropertyBase componetProperty = this.findComponentAttribute(passThrough.componentAttribute);
            passThrough.type = componetProperty.getType().toString();
            for (EventName event : componetProperty.getEventNames()) {
                passThrough.behaviors.add(event.getName());
            }
        }
        catch (NoSuchElementException e) {
            passThrough.type = Object.class.getName();
        }
        return passThrough;
    }

    private WriteAttributeStatement createAttributeStatement() {
        WriteAttributeStatement writeAttributeStatement = (WriteAttributeStatement)this.statementProvider.get();
        this.addStatement(writeAttributeStatement);
        return writeAttributeStatement;
    }

    private PropertyBase findComponentAttribute(String name) throws NoSuchElementException {
        return (PropertyBase)Iterables.find(this.componentAttributes, (Predicate)new Named.NamePredicate(name));
    }

    private WriteAttributeStatement setupAttributeStatement(QName qName, Object value, Attribute schemaAttribute) {
        WriteAttributeStatement writeAttributeStatement = this.createAttributeStatement();
        String defaultValue = schemaAttribute.getDefaultValue();
        switch (schemaAttribute.getKind()) {
            case GENERIC: {
                writeAttributeStatement.setAttribute(qName, value, defaultValue);
                break;
            }
            case URI: {
                writeAttributeStatement.setUriAttribute(qName, value, defaultValue);
                break;
            }
            case BOOLEAN: {
                writeAttributeStatement.setBooleanAttribute(qName, value, defaultValue);
                break;
            }
            default: {
                this.logger.error((CharSequence)("Unknown kind of statement, fix case operator code: " + schemaAttribute.getKind()));
            }
        }
        return writeAttributeStatement;
    }

    protected Attribute.Kind getAttributeKind(String attributeName) {
        return this.getSchemaAttribute(attributeName).getKind();
    }

    protected Attribute getSchemaAttribute(String attributeName) {
        Element schemaElement;
        Map elements = this.attributesSchema.getElements();
        String elementLocalName = this.elementName.getLocalPart();
        Attribute result = Template.isDefaultNamespace(this.elementName) && elements.containsKey(elementLocalName) ? ((schemaElement = (Element)elements.get(elementLocalName)).getAttributes().containsKey(attributeName) ? (Attribute)schemaElement.getAttributes().get(attributeName) : this.getGenericAttribute(attributeName)) : this.getGenericAttribute(attributeName);
        return result;
    }

    protected Attribute getGenericAttribute(String name) {
        Attribute attribute = new Attribute(name);
        attribute.setKind(Attribute.Kind.GENERIC);
        if ("class".equals(name)) {
            attribute.setComponentAttributeName("styleClass");
        }
        return attribute;
    }
}

