/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.statements;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.generate.freemarker.FreeMarkerRenderer;
import org.richfaces.cdk.templatecompiler.ELParser;
import org.richfaces.cdk.templatecompiler.TemplateModel;
import org.richfaces.cdk.templatecompiler.builder.model.JavaField;
import org.richfaces.cdk.templatecompiler.builder.model.JavaImport;
import org.richfaces.cdk.templatecompiler.builder.model.Variables;
import org.richfaces.cdk.templatecompiler.el.ParsingException;
import org.richfaces.cdk.templatecompiler.el.types.ComplexType;
import org.richfaces.cdk.templatecompiler.el.types.ELType;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;
import org.richfaces.cdk.templatecompiler.statements.FreeMarkerTemplateStatementBase;
import org.richfaces.cdk.templatecompiler.statements.HelperMethod;
import org.richfaces.cdk.templatecompiler.statements.TypedTemplateStatement;

public class ForEachStatement
extends FreeMarkerTemplateStatementBase {
    private static final String FOR_EACH_LOOP_CLASS = "org.richfaces.ui.common.ForEachLoop";
    private static final String FOR_EACH_LOOP_STATUS_CLASS = "org.richfaces.ui.common.ForEachLoop.Status";
    private static String LOOP_OBJECT_PREFIX = "forEach";
    private static volatile int LOOP_OBJECT_COUNTER = 1;
    private String itemsExpression;
    private TypedTemplateStatement itemsStatement;
    private ELType itemsType;
    private String var;
    private String loopObject;
    private String varStatus;
    private Integer begin;
    private Integer end;
    private Integer step;
    private ELType varType;
    private final ELParser parser;
    private final Logger log;
    private final TypesFactory typesFactory;
    private boolean iterator = false;
    private boolean iterable = false;

    @Inject
    public ForEachStatement(@TemplateModel FreeMarkerRenderer renderer, ELParser parser, Logger log, TypesFactory typesFactory) {
        super(renderer, "for-each");
        this.parser = parser;
        this.log = log;
        this.typesFactory = typesFactory;
    }

    public TypedTemplateStatement getItemsExpression() {
        return this.itemsStatement;
    }

    public String getVar() {
        return this.var;
    }

    public ELType getVarType() {
        return this.varType;
    }

    public String getVarStatus() {
        return this.varStatus;
    }

    public Integer getBegin() {
        return this.begin;
    }

    public Integer getEnd() {
        return this.end;
    }

    public Integer getStep() {
        return this.step;
    }

    public String getLoopObject() {
        return this.loopObject;
    }

    public boolean isLoopObjectRequired() {
        return this.varStatus != null || this.begin != null || this.end != null || this.step != null;
    }

    public void setItemsExpression(String itemsExpression, String var, String varStatus, Integer begin, Integer end, Integer step) {
        try {
            this.itemsExpression = itemsExpression;
            this.itemsStatement = this.parser.parse(itemsExpression, (Variables)this, Object.class.getName());
            this.itemsType = this.itemsStatement.getType();
            this.itemsStatement.setParent(this);
            this.varType = this.itemsStatement.getType().getContainerType();
            this.var = var;
            this.varStatus = varStatus;
            this.begin = begin;
            this.end = end;
            this.step = step;
            this.setVariable(var, this.varType);
            if (this.isLoopObjectRequired()) {
                this.initializeLoopObjectIteration();
            } else {
                this.initializePrimitiveIteration();
            }
        }
        catch (ParsingException e) {
            this.log.error((CharSequence)"Error parsing expression for iteration in <foreach> statement", (Throwable)e);
        }
    }

    public void initializePrimitiveIteration() {
        if (this.itemsType.isArray()) {
            this.iterable = true;
        } else {
            if (this.itemsType instanceof ComplexType) {
                this.itemsType = ((ComplexType)this.itemsType).getRawType();
            }
            if (this.typesFactory.getType((Type)((Object)Iterable.class)).isAssignableFrom(this.itemsType)) {
                this.iterable = true;
            } else if (this.typesFactory.getType((Type)((Object)Iterator.class)).isAssignableFrom(this.itemsType)) {
                this.iterator = true;
            }
        }
        if (!this.iterable && !this.iterator) {
            this.log.info((CharSequence)("The <foreach> expression " + this.itemsExpression + " is not array, Iterable nor Iterator. It will be treated as single object."));
        }
    }

    public void initializeLoopObjectIteration() {
        this.loopObject = LOOP_OBJECT_PREFIX + LOOP_OBJECT_COUNTER++;
        this.addImport(FOR_EACH_LOOP_CLASS);
        this.setVariable(this.loopObject, this.typesFactory.getType(FOR_EACH_LOOP_CLASS));
        if (this.varStatus != null) {
            this.setVariable(this.varStatus, this.typesFactory.getType(FOR_EACH_LOOP_STATUS_CLASS));
        }
    }

    @Override
    public Iterable<JavaImport> getRequiredImports() {
        return Iterables.concat(super.getRequiredImports(), this.itemsStatement.getRequiredImports());
    }

    @Override
    public Iterable<HelperMethod> getRequiredMethods() {
        return Iterables.concat(super.getRequiredMethods(), this.itemsStatement.getRequiredMethods());
    }

    @Override
    public Iterable<JavaField> getRequiredFields() {
        return Iterables.concat(super.getRequiredFields(), this.itemsStatement.getRequiredFields());
    }

    public boolean isIterable() {
        return this.iterable;
    }

    public boolean isIterator() {
        return this.iterator;
    }
}

