/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.statements;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.richfaces.cdk.util.JavaUtils;

public enum HelperMethod {
    TO_STRING_CONVERSION("convertToString", String.class, Object.class),
    TO_BOOLEAN_CONVERSION("convertToBoolean", Boolean.TYPE, Object.class),
    TO_INTEGER_CONVERSION("convertToInteger", Integer.class, Object.class),
    TO_BYTE_CONVERSION("convertToByte", Byte.class, Object.class),
    TO_SHORT_CONVERSION("convertToShort", Short.class, Object.class),
    TO_LONG_CONVERSION("convertToLong", Long.class, Object.class),
    TO_FLOAT_CONVERSION("convertToFloat", Float.class, Object.class),
    TO_DOUBLE_CONVERSION("convertToDouble", Double.class, Object.class),
    TO_CHAR_CONVERSION("convertToChar", Character.class, Object.class),
    EMPTINESS_CHECK("isEmpty", Boolean.TYPE, Object.class),
    EQUALS_CHECK("isEqual", Boolean.TYPE, Object.class, Object.class),
    SHOULD_RENDER_ATTRIBUTE("shouldRenderAttribute", Boolean.TYPE, Object.class),
    CREATE_ATTRIBUTES("attributes", "Attributes", new String[0]),
    RENDER_ATTRIBUTES_SET("renderPassThroughAttributes", Void.TYPE, FacesContext.class, UIComponent.class, Collection.class),
    RENDER_ATTRIBUTE("renderAttribute", Void.TYPE, FacesContext.class, String.class, Object.class),
    ADD_TO_SCRIPT_HASH("addToScriptHash", Void.TYPE.getName(), Map.class.getName(), String.class.getName(), Object.class.getName(), Object.class.getName(), "ScriptHashVariableWrapper"),
    ADD_TO_SCRIPT_HASH_ATTRIBUTES("addToScriptHash", Void.TYPE.getName(), Map.class.getName(), FacesContext.class.getName(), UIComponent.class.getName(), "Attributes", "ScriptHashVariableWrapper"),
    TO_SCRIPT_ARGS("toScriptArgs", String.class, Object[].class),
    CONCAT("concat", String.class, String[].class),
    HAS_FACET("hasFacet", Boolean.TYPE, UIComponent.class, String.class);

    public static final EnumMap<HelperMethod, String> METHOD_NAMES;
    private static final Set<HelperMethod> CONVERSION_METHODS;
    private final String name;
    private final String returnType;
    private final String[] argumentTypes;

    private HelperMethod(String name, String returnType, String ... argumentTypes) {
        this.name = name;
        this.returnType = returnType;
        this.argumentTypes = argumentTypes;
    }

    private HelperMethod(String name, Class<?> returnType, Class<?> ... argumentTypes) {
        this(name, (String)JavaUtils.CLASS_TO_CLASS_NAME.apply(returnType), HelperMethod.transformClassesToClassNames(argumentTypes));
    }

    private static String[] transformClassesToClassNames(Class<?>[] s) {
        Iterator transformed = Iterators.transform((Iterator)Iterators.forArray((Object[])s), JavaUtils.CLASS_TO_CLASS_NAME);
        return (String[])Iterators.toArray((Iterator)transformed, String.class);
    }

    public String getName() {
        return this.name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String[] getArgumentTypes() {
        return this.argumentTypes;
    }

    public static Set<HelperMethod> getConversionMethods() {
        return CONVERSION_METHODS;
    }

    static {
        METHOD_NAMES = Maps.newEnumMap(HelperMethod.class);
        CONVERSION_METHODS = EnumSet.of(TO_STRING_CONVERSION, new HelperMethod[]{TO_BOOLEAN_CONVERSION, TO_INTEGER_CONVERSION, TO_BYTE_CONVERSION, TO_SHORT_CONVERSION, TO_LONG_CONVERSION, TO_FLOAT_CONVERSION, TO_DOUBLE_CONVERSION, TO_CHAR_CONVERSION});
        for (HelperMethod method : HelperMethod.values()) {
            METHOD_NAMES.put(method, method.getName());
        }
    }
}

