/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.statements;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.templatecompiler.ELParser;
import org.richfaces.cdk.templatecompiler.builder.model.JavaField;
import org.richfaces.cdk.templatecompiler.builder.model.JavaImport;
import org.richfaces.cdk.templatecompiler.builder.model.Variables;
import org.richfaces.cdk.templatecompiler.el.ParsingException;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;
import org.richfaces.cdk.templatecompiler.statements.HelperMethod;
import org.richfaces.cdk.templatecompiler.statements.StatementsContainer;
import org.richfaces.cdk.templatecompiler.statements.TypedTemplateStatement;

public final class IfStatement
extends StatementsContainer {
    private TypedTemplateStatement testStatement;
    private final ELParser parser;
    private final Logger log;

    @Inject
    public IfStatement(ELParser parser, Logger log) {
        this.parser = parser;
        this.log = log;
    }

    public void setTest(String test) {
        try {
            this.testStatement = this.parser.parse(test, (Variables)this, TypesFactory.BOOLEAN_TYPE);
            this.testStatement.setParent(this);
        }
        catch (ParsingException e) {
            this.log.error((CharSequence)"Error parsing if statement condition", (Throwable)e);
        }
    }

    public TypedTemplateStatement getTest() {
        return this.testStatement;
    }

    @Override
    public Iterable<JavaImport> getRequiredImports() {
        return Iterables.concat(super.getRequiredImports(), this.testStatement.getRequiredImports());
    }

    @Override
    public Iterable<HelperMethod> getRequiredMethods() {
        return Iterables.concat(super.getRequiredMethods(), this.testStatement.getRequiredMethods());
    }

    @Override
    public Iterable<JavaField> getRequiredFields() {
        return Iterables.concat(super.getRequiredFields(), this.testStatement.getRequiredFields());
    }
}

