/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.statements;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.generate.freemarker.FreeMarkerRenderer;
import org.richfaces.cdk.templatecompiler.ELParser;
import org.richfaces.cdk.templatecompiler.Fragment;
import org.richfaces.cdk.templatecompiler.FragmentStore;
import org.richfaces.cdk.templatecompiler.TemplateModel;
import org.richfaces.cdk.templatecompiler.builder.model.Argument;
import org.richfaces.cdk.templatecompiler.builder.model.Variables;
import org.richfaces.cdk.templatecompiler.el.ParsingException;
import org.richfaces.cdk.templatecompiler.statements.FreeMarkerTemplateStatementBase;
import org.richfaces.cdk.templatecompiler.statements.TypedTemplateStatement;

public class RenderFragmentStatement
extends FreeMarkerTemplateStatementBase {
    private ELParser parser;
    private Logger logger;
    private String methodName;
    private Map<QName, String> attributes;
    private boolean extendingRendererBase;
    private List<String> arguments;
    private FragmentStore fragmentStore;

    @Inject
    public RenderFragmentStatement(@TemplateModel FreeMarkerRenderer renderer, ELParser parser, Logger logger) {
        super(renderer, "render-fragment");
        this.parser = parser;
        this.logger = logger;
    }

    public List<String> getArguments() {
        if (this.arguments == null) {
            this.arguments = Lists.newLinkedList();
            Fragment fragment = this.fragmentStore.getFragment(this.methodName);
            for (Argument argument : fragment.getAllArguments()) {
                String argumentValue = this.getAttributeValue(argument);
                this.arguments.add(argumentValue);
            }
        }
        return this.arguments;
    }

    private String getAttributeValue(Argument argument) {
        String argumentName = argument.getName();
        if (this.attributes != null) {
            for (Map.Entry<QName, String> entry : this.attributes.entrySet()) {
                QName qname = entry.getKey();
                String attributeName = qname.getLocalPart();
                if (!argumentName.equals(attributeName)) continue;
                String valueExpression = entry.getValue();
                return this.parseValueExpression(argument, valueExpression);
            }
        }
        if (argument.isRequired()) {
            throw new IllegalStateException("Missing value for required attribute '" + argumentName + "'");
        }
        if (argument.getDefault() != null) {
            String valueExpression = argument.getDefault();
            return this.parseValueExpression(argument, valueExpression);
        }
        return "null";
    }

    private String parseValueExpression(Argument argument, String valueExpression) {
        try {
            TypedTemplateStatement statement = this.parser.parse(valueExpression, (Variables)this, argument.getType());
            String code = statement.getCode();
            this.addRequiredMethods(statement.getRequiredMethods());
            return code;
        }
        catch (ParsingException e) {
            this.logger.error((CharSequence)("Error parse renderFragment argument " + argument.getName() + " expression: " + valueExpression), (Throwable)e);
            return valueExpression;
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public boolean isExtendingRendererBase() {
        return this.extendingRendererBase;
    }

    public void setExtendingRendererBase(boolean extendingRendererBase) {
        this.extendingRendererBase = extendingRendererBase;
    }

    public Map<QName, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<QName, String> attributes) {
        this.attributes = attributes;
    }

    public void setFragmentStore(FragmentStore fragmentStore) {
        this.fragmentStore = fragmentStore;
    }
}

