/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.statements;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.generate.freemarker.FreeMarkerRenderer;
import org.richfaces.cdk.templatecompiler.ELParser;
import org.richfaces.cdk.templatecompiler.TemplateModel;
import org.richfaces.cdk.templatecompiler.builder.model.Variables;
import org.richfaces.cdk.templatecompiler.el.ParsingException;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;
import org.richfaces.cdk.templatecompiler.statements.FreeMarkerTemplateStatementBase;
import org.richfaces.cdk.templatecompiler.statements.TemplateStatement;

public class WriteTextStatement
extends FreeMarkerTemplateStatementBase {
    private TemplateStatement textStatement;
    private final ELParser parser;
    private final Logger log;

    @Inject
    public WriteTextStatement(@TemplateModel FreeMarkerRenderer renderer, ELParser parser, Logger log) {
        super(renderer, "write-text");
        this.parser = parser;
        this.log = log;
    }

    public TemplateStatement getValue() {
        return this.textStatement;
    }

    @Override
    public List<TemplateStatement> getStatements() {
        return Collections.singletonList(this.textStatement);
    }

    public void setExpression(String textExpression) {
        try {
            this.textStatement = this.parser.parse(textExpression, (Variables)this, TypesFactory.OBJECT_TYPE);
            this.textStatement.setParent(this);
        }
        catch (ParsingException e) {
            this.log.error((CharSequence)"Error parsing EL expression", (Throwable)e);
        }
    }
}

