/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.xmlconfig;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.richfaces.cdk.CdkClassLoader;
import org.richfaces.cdk.FileManager;
import org.richfaces.cdk.Source;
import org.richfaces.cdk.Sources;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class CdkEntityResolver
implements EntityResolver2 {
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String JAXP_SCHEMA_LOCATION = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String URN_ATTRIBUTES = "urn:attributes:";
    public static final String URN_CONFIG = "urn:config:";
    public static final String URN_RESOURCE = "urn:resource:";
    public static final String URN_TEMPLATES = "urn:templates:";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String RESOURCE_PREFIX = "";
    private static final String ATTRIBUTES_PREFIX = "META-INF/cdk/attributes/";
    private static final String SYSTEM_PREFIX = "/META-INF/schema";
    private static final String URN_SYSTEM = "urn:system:";
    private static final ImmutableMap<String, String> SYSTEM_ENTITIES = ImmutableMap.builder().put((Object)"http://java.sun.com/xml/ns/javaee/web-facesconfig_2_0.xsd", (Object)"/web-facesconfig_2_0.xsd").put((Object)"http://java.sun.com/xml/ns/javaee/web-facesuicomponent_2_0.xsd", (Object)"/web-facesuicomponent_2_0.xsd").put((Object)"http://java.sun.com/xml/ns/javaee/web-partialresponse_2_0.xsd", (Object)"/web-partialresponse_2_0.xsd").put((Object)"http://java.sun.com/xml/ns/javaee/web-facesconfig_1_2.xsd", (Object)"/web-facesconfig_1_2.xsd").put((Object)"http://java.sun.com/xml/ns/javaee/javaee_5.xsd", (Object)"/javaee_5.xsd").put((Object)"http://java.sun.com/xml/ns/javaee/javaee_web_services_1_2.xsd", (Object)"/javaee_web_services_1_2.xsd").put((Object)"http://java.sun.com/xml/ns/javaee/javaee_web_services_client_1_2.xsd", (Object)"/javaee_web_services_client_1_2.xsd").put((Object)"http://www.w3.org/2001/03/XMLSchema.dtd", (Object)"/XMLSchema.dtd").put((Object)"http://www.w3.org/2001/03/xml.xsd", (Object)"/xml.xsd").put((Object)"http://www.w3.org/2001/xml.xsd", (Object)"/xml.xsd").put((Object)"http://jboss.org/schema/richfaces/cdk/cdk-template.xsd", (Object)"/cdk-template.xsd").put((Object)"http://jboss.org/schema/richfaces/cdk/cdk-jstl-core.xsd", (Object)"/cdk-jstl-core.xsd").put((Object)"http://jboss.org/schema/richfaces/cdk/cdk-schemas-aggregation.xsd", (Object)"/cdk-schemas-aggregation.xsd").put((Object)"http://jboss.org/schema/richfaces/cdk/cdk-composite.xsd", (Object)"/cdk-composite.xsd").put((Object)"http://jboss.org/schema/richfaces/cdk/xhtml-el.xsd", (Object)"/xhtml-el.xsd").build();
    @Inject
    private CdkClassLoader loader;
    @Inject
    @Source(value=Sources.FACES_CONFIGS)
    private FileManager facesConfigFolders;
    @Inject
    @Source(value=Sources.RENDERER_TEMPLATES)
    private FileManager rendererTemplatesFolders;

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return null;
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        String temSystemId = systemId;
        if (null != temSystemId) {
            try {
                URI sourceURI = URI.create(temSystemId);
                if (!sourceURI.isAbsolute() && null != baseURI) {
                    temSystemId = URI.create(baseURI).resolve(sourceURI).toString();
                }
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return this.resolveSystemId(temSystemId);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource entity = null;
        if (null != systemId) {
            entity = this.resolveSystemId(systemId);
        }
        return entity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected InputSource resolveSystemId(String systemId) throws IOException {
        InputSource entity = null;
        String systemIdInternal = SYSTEM_ENTITIES.containsKey((Object)systemId) ? URN_SYSTEM + (String)SYSTEM_ENTITIES.get((Object)systemId) : systemId;
        if (systemIdInternal.startsWith(URN_SYSTEM)) {
            String path = systemIdInternal.substring(URN_SYSTEM.length());
            URL url = CdkEntityResolver.class.getResource(SYSTEM_PREFIX + path);
            InputStream inputStream = null;
            if (null == url) throw new FileNotFoundException("Resource not found in generator class path: /META-INF/schema" + path);
            inputStream = url.openStream();
            entity = new InputSource(inputStream);
            entity.setSystemId(url.toString());
        } else if (systemIdInternal.startsWith(URN_RESOURCE)) {
            String path = systemIdInternal.substring(URN_RESOURCE.length());
            URL url = this.loader.getResource(RESOURCE_PREFIX + path);
            InputStream inputStream = null;
            if (null == url) throw new FileNotFoundException("Resource not found in project class path: " + path);
            inputStream = url.openStream();
            entity = new InputSource(inputStream);
            entity.setSystemId(url.toString());
        } else if (systemIdInternal.startsWith(URN_ATTRIBUTES)) {
            String path = systemIdInternal.substring(URN_ATTRIBUTES.length());
            InputStream inputStream = this.loader.getResourceAsStream(ATTRIBUTES_PREFIX + path);
            if (null == inputStream) {
                inputStream = this.getClass().getClassLoader().getResourceAsStream(ATTRIBUTES_PREFIX + path);
            }
            if (null == inputStream) throw new FileNotFoundException("Resource not found in class path: META-INF/cdk/attributes/" + path);
            entity = new InputSource(inputStream);
        } else if (systemIdInternal.startsWith(URN_CONFIG)) {
            String path = systemIdInternal.substring(URN_CONFIG.length());
            entity = this.getProjectInputSource(this.facesConfigFolders, path);
        } else if (systemIdInternal.startsWith(URN_TEMPLATES)) {
            String path = systemIdInternal.substring(URN_TEMPLATES.length());
            entity = this.getProjectInputSource(this.rendererTemplatesFolders, path);
        }
        if (null == entity || entity.getSystemId() != null) return entity;
        entity.setSystemId(systemId);
        return entity;
    }

    protected InputSource getProjectInputSource(FileManager folders, String path) throws FileNotFoundException {
        InputSource entity = null;
        File configFile = folders.getFile(path);
        if (null == configFile || !configFile.exists()) {
            throw new FileNotFoundException("File not found in project : " + path);
        }
        FileInputStream inputStream = new FileInputStream(configFile);
        entity = new InputSource(inputStream);
        return entity;
    }
}

