/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.xmlconfig;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.cocoon.pipeline.component.sax.XIncludeTransformer;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.xmlconfig.FacesConfigNamespacePreffixMapper;
import org.richfaces.cdk.xmlconfig.JAXB;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.helpers.XMLReaderFactory;

public class JAXBBinding
implements JAXB {
    private static final FacesConfigNamespacePreffixMapper PREFFIX_MAPPER = new FacesConfigNamespacePreffixMapper();
    @Inject
    private EntityResolver2 resolver;
    @Inject
    private Logger log;

    @Override
    public <T> T unmarshal(File file, String schemaLocation, Class<T> bindClass) throws CdkException, FileNotFoundException {
        InputSource input = new InputSource(new FileInputStream(file));
        input.setSystemId(file.toURI().toString());
        T unmarshal = this.unmarshal(schemaLocation, bindClass, input);
        return unmarshal;
    }

    @Override
    public <T> T unmarshal(String url, String schemaLocation, Class<T> bindClass) throws CdkException, FileNotFoundException {
        try {
            InputSource inputSource;
            try {
                inputSource = this.resolver.resolveEntity(null, url);
            }
            catch (SAXException e) {
                inputSource = null;
            }
            if (null == inputSource) {
                inputSource = new InputSource(url);
            }
            T unmarshal = this.unmarshal(schemaLocation, bindClass, inputSource);
            return unmarshal;
        }
        catch (IOException e) {
            throw new FileNotFoundException("XML file not found at " + url);
        }
    }

    <T> T unmarshal(String schemaLocation, Class<T> bindClass, InputSource inputSource) throws CdkException {
        Object unmarshal = null;
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setEntityResolver(this.resolver);
            xmlReader.setFeature("http://xml.org/sax/features/validation", true);
            xmlReader.setFeature("http://apache.org/xml/features/validation/schema", true);
            xmlReader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            Unmarshaller u = JAXBContext.newInstance((Class[])new Class[]{bindClass}).createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new ValidationEventCollector());
            XIncludeTransformer xIncludeTransformer = new XIncludeTransformer(this.log);
            if (null != inputSource.getSystemId()) {
                xIncludeTransformer.setBaseUri(new URI(inputSource.getSystemId()));
            }
            UnmarshallerHandler unmarshallerHandler = u.getUnmarshallerHandler();
            xIncludeTransformer.setContentHandler((ContentHandler)unmarshallerHandler);
            xIncludeTransformer.setResolver(this.resolver);
            xmlReader.setContentHandler((ContentHandler)xIncludeTransformer);
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", xIncludeTransformer);
            xmlReader.parse(inputSource);
            unmarshal = unmarshallerHandler.getResult();
        }
        catch (JAXBException e) {
            throw new CdkException("JAXB Unmarshaller error: " + e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new CdkException("Invalid XML source URI: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new CdkException("JAXB Unmarshaller input error: " + e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new CdkException("XML error: " + e.getMessage(), (Throwable)e);
        }
        return (T)unmarshal;
    }

    @Override
    public <T> void marshal(Writer output, String schemaLocation, T model) throws CdkException {
        try {
            StreamResult result = new StreamResult(output);
            this.marshal(result, schemaLocation, model);
            output.flush();
            output.close();
        }
        catch (FileNotFoundException e) {
            throw new CdkException("File not found", (Throwable)e);
        }
        catch (IOException e) {
            throw new CdkException("XML file writting error", (Throwable)e);
        }
    }

    @Override
    public <T> void marshal(Result output, String schemaLocation, T model) throws CdkException {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{model.getClass()});
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            if (null != schemaLocation) {
                marshaller.setProperty("jaxb.schemaLocation", (Object)schemaLocation);
                marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)PREFFIX_MAPPER);
            }
            marshaller.marshal(model, output);
        }
        catch (JAXBException e) {
            throw new CdkException("JAXB Marshaller error", (Throwable)e);
        }
    }

    private void closeSource(Source source) {
        if (source instanceof SAXSource) {
            SAXSource saxSource = (SAXSource)source;
            InputSource inputSource = saxSource.getInputSource();
            try {
                Reader stream = inputSource.getCharacterStream();
                if (null != stream) {
                    stream.close();
                } else {
                    InputStream byteStream = inputSource.getByteStream();
                    if (null != byteStream) {
                        byteStream.close();
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public static boolean isCollections(Class<?> targetType, Object propertyValue) {
        return Collection.class.isAssignableFrom(targetType) && propertyValue instanceof Collection;
    }
}

