/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.xmlconfig.model;

import java.lang.reflect.Method;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.model.ConfigExtension;
import org.richfaces.cdk.model.Extensible;
import org.richfaces.cdk.util.JavaUtils;

public abstract class AdapterBase<Bean, Model>
extends XmlAdapter<Bean, Model> {
    public Bean marshal(Model model) throws CdkException {
        Bean bean = null;
        try {
            bean = this.createBean(this.getBeanClass(model), model);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        this.postMarshal(model, bean);
        return bean;
    }

    public Bean createBean(Class<? extends Bean> beanClass, Model model) throws CdkException {
        try {
            Bean bean = beanClass.newInstance();
            JavaUtils.copyProperties(model, bean);
            if (model instanceof Extensible && bean instanceof Extensible) {
                this.copyExtensions((Extensible)model, (Extensible)bean, true);
            }
            return bean;
        }
        catch (InstantiationException e) {
            throw new CdkException("JAXB adapter class instantiation error", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CdkException("JAXB adapter class instantiation error", (Throwable)e);
        }
    }

    protected void postMarshal(Model model, Bean bean) {
    }

    protected abstract Class<? extends Bean> getBeanClass(Model var1);

    public Model unmarshal(Bean bean) throws CdkException {
        Model model = this.createModelElement(this.getModelClass(bean), bean);
        this.postUnmarshal(bean, model);
        return model;
    }

    protected <D, E extends ConfigExtension> E createExtension(D destination) throws NoSuchMethodException, InstantiationException, IllegalAccessException {
        Method method = destination.getClass().getMethod("getExtension", new Class[0]);
        return (E)((ConfigExtension)method.getReturnType().newInstance());
    }

    private void copyExtensions(Extensible<ConfigExtension> source, Extensible<ConfigExtension> destination, Boolean fromModel) {
        try {
            ConfigExtension sourceExtension = source.getExtension();
            if (null != sourceExtension) {
                Object destinationExtension = this.createExtension(destination);
                ((ConfigExtension)destinationExtension).setExtensions(sourceExtension.getExtensions());
                if (fromModel.booleanValue()) {
                    JavaUtils.copyProperties(source, destinationExtension);
                } else {
                    JavaUtils.copyProperties(sourceExtension, destination);
                }
                destination.setExtension((ConfigExtension)destinationExtension);
            } else if (fromModel.booleanValue()) {
                Object destinationExtension = this.createExtension(destination);
                JavaUtils.copyProperties(source, destinationExtension);
                destination.setExtension((ConfigExtension)destinationExtension);
            }
        }
        catch (Exception e) {
            throw new CdkException("Properties copiing error", (Throwable)e);
        }
    }

    protected Model createModelElement(Class<? extends Model> modelClass, Bean adapter) {
        try {
            Model modelBean = modelClass.newInstance();
            JavaUtils.copyProperties(adapter, modelBean);
            if (adapter instanceof Extensible && modelBean instanceof Extensible) {
                this.copyExtensions((Extensible)adapter, (Extensible)modelBean, false);
            }
            return modelBean;
        }
        catch (Exception e) {
            throw new CdkException("CDK model class instantiation error", (Throwable)e);
        }
    }

    protected void postUnmarshal(Bean bean, Model model) {
    }

    protected abstract Class<? extends Model> getModelClass(Bean var1);
}

