/*
 * Decompiled with CFR 0.152.
 */
package net.sf.alchim.mojo.yuicompressor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aggregation {
    public File output;
    public File sourceDirectory;
    public String[] includes;
    public String[] excludes;
    public boolean removeIncluded = false;
    public boolean insertNewLine = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(File outputDirectory) throws Exception {
        List<File> files;
        if (null == this.sourceDirectory) {
            this.sourceDirectory = outputDirectory;
        }
        if ((files = this.getIncludedFiles()).size() != 0) {
            FileOutputStream out = new FileOutputStream(this.output);
            try {
                for (File file : files) {
                    FileInputStream in = new FileInputStream(file);
                    try {
                        IOUtil.copy((InputStream)in, (OutputStream)out);
                        if (this.insertNewLine) {
                            out.write(10);
                        }
                        if (!this.removeIncluded) continue;
                        file.delete();
                    }
                    finally {
                        IOUtil.close((InputStream)in);
                        in = null;
                    }
                }
            }
            finally {
                IOUtil.close((OutputStream)out);
                out = null;
            }
        }
    }

    protected List<File> getIncludedFiles() throws Exception {
        ArrayList<File> back = new ArrayList<File>();
        if (this.includes != null) {
            for (String include : this.includes) {
                this.addInto(include, back);
            }
        }
        return back;
    }

    private void addInto(String include, List<File> includedFiles) throws Exception {
        if (include.indexOf(42) > -1) {
            String[] rpaths;
            DirectoryScanner scanner = this.newScanner();
            scanner.setIncludes(new String[]{include});
            scanner.scan();
            for (String rpath : rpaths = scanner.getIncludedFiles()) {
                File file = new File(scanner.getBasedir(), rpath);
                if (includedFiles.contains(file)) continue;
                includedFiles.add(file);
            }
        } else {
            File file = new File(include);
            if (!file.isAbsolute()) {
                file = new File(this.output.getParentFile(), include);
            }
            if (!includedFiles.contains(file)) {
                includedFiles.add(file);
            }
        }
    }

    private DirectoryScanner newScanner() throws Exception {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.sourceDirectory);
        if (this.excludes != null && this.excludes.length != 0) {
            scanner.setExcludes(this.excludes);
        }
        scanner.addDefaultExcludes();
        return scanner;
    }
}

