/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.rd.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.codehaus.plexus.util.IOUtil;
import org.richfaces.cdk.rd.generator.ResourceAssembler;

public class ScriptAssembler
implements ResourceAssembler {
    protected Log log = new SystemStreamLog();
    private StringBuilder builder = new StringBuilder();

    public void assembly(URL resource) {
        this.log.info((CharSequence)("process resource : " + resource.getFile()));
        try {
            this.builder.append(IOUtil.toString((InputStream)resource.openStream()));
            this.builder.append("\n");
        }
        catch (IOException e) {
            this.log.error((CharSequence)("Error read resource: " + resource.getFile()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File file) {
        if (this.builder.length() > 0) {
            try {
                FileWriter fileWriter = new FileWriter(file);
                try {
                    IOUtil.copy((String)this.builder.toString(), (Writer)fileWriter);
                }
                finally {
                    fileWriter.close();
                }
            }
            catch (IOException e) {
                this.log.error((CharSequence)("Error write file: " + file.getAbsolutePath()), (Throwable)e);
            }
        }
    }
}

