/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.rd.handler;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.util.SelectorUtils;
import org.richfaces.cdk.rd.Component;
import org.richfaces.cdk.rd.Components;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentsHandler
extends DefaultHandler {
    private String[] INCLUDE_ALL_PATTERN = new String[]{"**"};
    private Map<String, Components> components;
    private Set<String> scripts = new LinkedHashSet<String>();
    private Set<String> styles = new LinkedHashSet<String>();
    private String[] scriptIncludes;
    private String[] scriptExcludes;
    private String[] styleIncludes;
    private String[] styleExcludes;
    private String[] namespaceIncludes;
    private String[] namespaceExcludes;
    private String[] componentIncludes;
    private String[] componentExcludes;

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.components != null && this.components.containsKey(uri)) {
            if (this.namespaceIncludes == null) {
                this.namespaceIncludes = this.INCLUDE_ALL_PATTERN;
            }
            if (this.doMatch(this.namespaceIncludes, uri, true) && !this.doMatch(this.namespaceExcludes, uri, true)) {
                Components library = this.components.get(uri);
                List<Component> components = library.getComponents();
                if (this.componentIncludes == null) {
                    this.componentIncludes = this.INCLUDE_ALL_PATTERN;
                }
                for (Component component : components) {
                    String componentName = component.getComponentName();
                    if (!localName.equals(componentName) || !this.doMatch(this.componentIncludes, componentName, false) || this.doMatch(this.componentExcludes, componentName, false)) continue;
                    this.collectScripts(component);
                    this.collectStyles(component);
                }
            }
        }
    }

    private void collectStyles(Component component) {
        if (this.styleIncludes == null) {
            this.styleIncludes = this.INCLUDE_ALL_PATTERN;
        }
        for (String style : component.getStyles()) {
            if (!this.doMatch(this.styleIncludes, style, true) || this.doMatch(this.styleExcludes, style, true)) continue;
            this.styles.add(style);
        }
    }

    private boolean doMatch(String[] patterns, String str, boolean matchPath) {
        boolean allow = false;
        if (patterns != null) {
            for (String excludePattern : patterns) {
                allow = matchPath ? SelectorUtils.matchPath((String)excludePattern, (String)str) : SelectorUtils.match((String)excludePattern, (String)str);
                if (allow) break;
            }
        }
        return allow;
    }

    private void collectScripts(Component component) {
        if (this.scriptIncludes == null) {
            this.scriptIncludes = this.INCLUDE_ALL_PATTERN;
        }
        for (String script : component.getScripts()) {
            if (!this.doMatch(this.scriptIncludes, script, true) || this.doMatch(this.scriptExcludes, script, true)) continue;
            this.scripts.add(script);
        }
    }

    public Set<String> getStyles() {
        return this.styles;
    }

    public Set<String> getScripts() {
        return this.scripts;
    }

    public Map<String, Components> getComponents() {
        return this.components;
    }

    public void setComponents(Map<String, Components> components) {
        this.components = components;
    }

    public String[] getNamespaceExcludes() {
        return this.namespaceExcludes;
    }

    public void setNamespaceExcludes(String[] namespaceExcludes) {
        this.namespaceExcludes = namespaceExcludes;
    }

    public String[] getComponentExcludes() {
        return this.componentExcludes;
    }

    public void setComponentExcludes(String[] componentExcludes) {
        this.componentExcludes = componentExcludes;
    }

    public String[] getScriptExcludes() {
        return this.scriptExcludes;
    }

    public void setScriptExcludes(String[] scriptExcludes) {
        this.scriptExcludes = scriptExcludes;
    }

    public String[] getStyleExcludes() {
        return this.styleExcludes;
    }

    public void setStyleExcludes(String[] styleExcludes) {
        this.styleExcludes = styleExcludes;
    }

    public String[] getScriptIncludes() {
        return this.scriptIncludes;
    }

    public void setScriptIncludes(String[] scriptIncludes) {
        this.scriptIncludes = scriptIncludes;
    }

    public String[] getStyleIncludes() {
        return this.styleIncludes;
    }

    public void setStyleIncludes(String[] styleIncludes) {
        this.styleIncludes = styleIncludes;
    }

    public String[] getNamespaceIncludes() {
        return this.namespaceIncludes;
    }

    public void setNamespaceIncludes(String[] namespaceIncludes) {
        this.namespaceIncludes = namespaceIncludes;
    }

    public String[] getComponentIncludes() {
        return this.componentIncludes;
    }

    public void setComponentIncludes(String[] componentIncludes) {
        this.componentIncludes = componentIncludes;
    }
}

