/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.rd.mojo;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.richfaces.cdk.rd.Components;
import org.richfaces.cdk.rd.generator.ResourceAssembler;
import org.richfaces.cdk.rd.generator.ResourcesGenerator;
import org.richfaces.cdk.rd.generator.ScriptAssembler;
import org.richfaces.cdk.rd.generator.StyleAssembler;
import org.richfaces.cdk.rd.handler.ComponentsHandler;
import org.richfaces.cdk.rd.utils.PluginUtils;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDependencyMojo
extends AbstractMojo {
    MavenProject project;
    private ArtifactFactory factory;
    private ArtifactResolver resolver;
    private ArtifactMetadataSource metadataSource;
    protected VelocityComponent velocity;
    private ArtifactRepository localRepository;
    private File webSourceDirectory;
    private File outputScriptDirectory;
    private String scriptFileName;
    private File outputStyleDirectory;
    private String styleFileName;
    private List<String> beforeScriptIncludes;
    private List<String> afterScriptIncludes;
    private List<String> beforeStyleIncludes;
    private List<String> afterStyleIncludes;
    private String[] scriptIncludes;
    private String[] scriptExcludes;
    private String[] styleIncludes;
    private String[] styleExcludes;
    private String[] namespaceIncludes;
    private String[] namespaceExcludes;
    private String[] componentIncludes;
    private String[] componentExcludes;
    private String[] xmlConfigPatterns;
    private String[] xhtmlIncludes;
    private String[] xhtmlExcludes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Set<Artifact> artifacts = this.resolveDependenciesArtifacts();
            Digester defaultDigester = this.createDigester();
            HashMap<String, Components> components = new HashMap<String, Components>();
            if (this.xmlConfigPatterns == null) {
                this.xmlConfigPatterns = PluginUtils.DEFAULT_CONFIG_PATTERNS;
            }
            for (Artifact artifact : artifacts) {
                FileObject jar = this.resolveArtifact(artifact);
                FileObject[] configs = PluginUtils.resolveConfigsFromJar(jar, this.xmlConfigPatterns);
                components.putAll(PluginUtils.processConfigs(configs, defaultDigester));
            }
            if (!this.webSourceDirectory.exists()) {
                this.webSourceDirectory.mkdirs();
            }
            ComponentsHandler handler = this.findComponents(this.webSourceDirectory, components, this.xhtmlIncludes, this.xhtmlExcludes);
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader contextClassLoader = this.createClassLoader();
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            if (contextClassLoader != null) {
                Set<String> scripts = handler.getScripts();
                File scriptFile = new File(this.outputScriptDirectory, this.scriptFileName + ".js");
                if (!scripts.isEmpty()) {
                    if (!this.outputScriptDirectory.exists()) {
                        this.outputScriptDirectory.mkdirs();
                    }
                    ScriptAssembler scriptAssembler = new ScriptAssembler();
                    this.mergeResources(scriptFile, scriptAssembler, this.beforeScriptIncludes, this.afterScriptIncludes, scripts);
                } else if (scriptFile.exists()) {
                    scriptFile.delete();
                }
                Set<String> styles = handler.getStyles();
                File styleFile = new File(this.outputStyleDirectory, this.styleFileName + ".xcss");
                if (!styles.isEmpty()) {
                    if (!this.outputStyleDirectory.exists()) {
                        this.outputStyleDirectory.mkdirs();
                    }
                    StyleAssembler styleAssembler = new StyleAssembler();
                    styleAssembler.setVelocityComponent(this.velocity);
                    this.mergeResources(styleFile, styleAssembler, this.beforeStyleIncludes, this.afterStyleIncludes, styles);
                } else if (styleFile.exists()) {
                    styleFile.delete();
                }
            }
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public void mergeResources(File assembly, ResourceAssembler assembler, List<String> beforeIncludes, List<String> afterIncludes, Collection<String> resources) {
        ResourcesGenerator styleGenerator = new ResourcesGenerator();
        styleGenerator.setAssembler(assembler);
        styleGenerator.setIncludesAfter(afterIncludes);
        styleGenerator.setIncludesBefore(beforeIncludes);
        styleGenerator.setResources(resources);
        styleGenerator.setAssemblyFile(assembly);
        styleGenerator.doAssembly();
        styleGenerator.writeToFile();
    }

    protected Set<Artifact> resolveDependenciesArtifacts() throws Exception {
        ArtifactResolutionResult result = null;
        List dependencies = this.project.getDependencies();
        Set artifacts = MavenMetadataSource.createArtifacts((ArtifactFactory)this.factory, (List)dependencies, null, null, (MavenProject)this.project);
        artifacts.add(this.project.getArtifact());
        result = this.resolver.resolveTransitively(artifacts, this.project.getArtifact(), Collections.EMPTY_LIST, this.localRepository, this.metadataSource);
        return result.getArtifacts();
    }

    public ComponentsHandler findComponents(File webSourceDir, Map<String, Components> components, String[] includes, String[] excludes) throws Exception {
        if (includes == null) {
            includes = PluginUtils.DEFAULT_PROCESS_INCLUDES;
        }
        if (excludes == null) {
            excludes = new String[]{};
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(webSourceDir);
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.addDefaultExcludes();
        scanner.scan();
        String[] collectedFiles = scanner.getIncludedFiles();
        ComponentsHandler handler = new ComponentsHandler();
        handler.setComponents(components);
        handler.setScriptIncludes(this.scriptIncludes);
        handler.setScriptExcludes(this.scriptExcludes);
        handler.setStyleIncludes(this.styleIncludes);
        handler.setStyleExcludes(this.styleExcludes);
        handler.setComponentIncludes(this.componentIncludes);
        handler.setComponentExcludes(this.componentExcludes);
        handler.setNamespaceIncludes(this.namespaceIncludes);
        handler.setNamespaceExcludes(this.namespaceExcludes);
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        SAXParser saxParser = saxParserFactory.newSAXParser();
        for (String processFile : collectedFiles) {
            File file = new File(webSourceDir, processFile);
            if (!file.exists()) continue;
            this.getLog().info((CharSequence)("process file: " + file.getName()));
            try {
                saxParser.parse(file, (DefaultHandler)handler);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Error process file: " + file.getAbsolutePath() + "\n" + e.getMessage()), (Throwable)e);
            }
        }
        return handler;
    }

    protected FileObject resolveArtifact(Artifact artifact) {
        FileObject jarFileObjects = null;
        if (artifact != null) {
            try {
                this.resolver.resolve(artifact, Collections.EMPTY_LIST, this.localRepository);
                this.getLog().info((CharSequence)("artifact " + artifact.getFile().getAbsolutePath() + " is resolved"));
            }
            catch (ArtifactResolutionException e) {
                this.getLog().error((CharSequence)("Error with resolve artifact " + artifact.getFile().getAbsolutePath() + "\n" + e.getMessage()), (Throwable)e);
            }
            catch (ArtifactNotFoundException e) {
                this.getLog().error((CharSequence)("Not found artifact " + artifact.getFile().getAbsolutePath() + "\n" + e.getMessage()), (Throwable)e);
            }
            File file = artifact.getFile();
            try {
                FileSystemManager manager = VFS.getManager();
                jarFileObjects = manager.resolveFile("jar://" + file.getAbsolutePath());
            }
            catch (FileSystemException e) {
                this.getLog().error((CharSequence)("Error during processing file: " + file.getAbsolutePath() + "\n" + e.getMessage()), (Throwable)e);
            }
        }
        return jarFileObjects;
    }

    public Digester createDigester() {
        return PluginUtils.createDefaultDigester();
    }

    protected ClassLoader createClassLoader() throws Exception {
        ClassLoader classLoader = null;
        Set<Artifact> artifacts = this.resolveDependenciesArtifacts();
        ClassWorld world = new ClassWorld();
        ClassRealm realm = world.newRealm("org.richfaces.cdk", Thread.currentThread().getContextClassLoader());
        ClassRealm childRealm = realm.createChildRealm("jar");
        for (Artifact jar : artifacts) {
            try {
                childRealm.addConstituent(jar.getFile().toURL());
            }
            catch (MalformedURLException e) {
                this.getLog().error((CharSequence)("Artifact url " + jar.getFile() + " is invalid"));
            }
        }
        List compileClasspathElements = this.project.getCompileClasspathElements();
        this.addResources(childRealm, compileClasspathElements);
        List scripts = this.project.getScriptSourceRoots();
        this.addResources(childRealm, scripts);
        List resources = this.project.getResources();
        this.addResources(childRealm, resources);
        childRealm.addConstituent(this.webSourceDirectory.toURI().toURL());
        classLoader = childRealm.getClassLoader();
        return classLoader;
    }

    private void addResources(ClassRealm realm, List resources) {
        if (realm != null && resources != null) {
            for (Object path : resources) {
                URL url = null;
                String formatted = null;
                if (path instanceof String) {
                    formatted = (String)path;
                } else if (path instanceof Resource) {
                    formatted = ((Resource)path).getDirectory();
                }
                if (formatted == null) continue;
                File file = new File(formatted);
                try {
                    url = file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    this.getLog().error((CharSequence)("Resource url " + file.getPath() + " is invalid"));
                }
                realm.addConstituent(url);
            }
        }
    }
}

