/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.rd.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.vfs.FileObject;
import org.richfaces.cdk.rd.Component;
import org.richfaces.cdk.rd.Components;
import org.richfaces.cdk.rd.JarResourceScanner;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginUtils {
    public static String[] DEFAULT_CONFIG_PATTERNS = new String[]{"**/*.component-dependencies.xml"};
    public static String[] DEFAULT_PROCESS_INCLUDES = new String[]{"**/*.xhtml"};

    public static FileObject[] resolveConfigsFromJar(FileObject jarFileObject, String[] patterns) throws IOException {
        FileObject[] result = new FileObject[]{};
        JarResourceScanner jarScanner = new JarResourceScanner();
        jarScanner.setBaseFile(jarFileObject);
        jarScanner.setPatterns(patterns);
        jarScanner.doScan();
        result = jarScanner.getResult().toArray(new FileObject[jarScanner.getResult().size()]);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Components> processConfigs(FileObject[] configs, Digester digester) throws SAXException, IOException {
        HashMap<String, Components> collector = new HashMap<String, Components>();
        for (FileObject config : configs) {
            InputStream configInputStream = config.getContent().getInputStream();
            try {
                Components components = (Components)digester.parse(configInputStream);
                collector.put(components.getNamespace(), components);
            }
            finally {
                configInputStream.close();
            }
        }
        return collector;
    }

    public static Digester createDefaultDigester() {
        Digester digester = new Digester();
        digester.addObjectCreate("components", Components.class);
        digester.addCallMethod("components/namespace", "setNamespace", 0);
        digester.addObjectCreate("components/component", Component.class);
        digester.addCallMethod("components/component/name", "setComponentName", 0);
        digester.addCallMethod("components/component/scripts/script", "addScript", 0);
        digester.addCallMethod("components/component/styles/style", "addStyle", 0);
        digester.addSetNext("components/component", "addComponent");
        return digester;
    }
}

