/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.rd.generator;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.richfaces.cdk.rd.generator.ResourceAssembler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesGenerator {
    private File assemblyFile;
    private Log log;
    private Collection<String> resources;
    private List<String> includesBefore;
    private List<String> includesAfter;
    private ResourceAssembler assembler;

    public ResourcesGenerator(Log log) {
        this.log = log;
    }

    public void doAssembly() {
        if (this.resources != null) {
            if (this.includesBefore != null && !this.includesBefore.isEmpty()) {
                this.iterate(this.includesBefore);
            }
            if (this.resources != null && !this.resources.isEmpty()) {
                this.iterate(this.resources);
            }
            if (this.includesAfter != null && !this.includesAfter.isEmpty()) {
                this.iterate(this.includesAfter);
            }
        }
    }

    private void iterate(Collection<String> resources) {
        for (String resourceName : resources) {
            URL resource = this.getResourceURL(resourceName);
            this.log.info((CharSequence)("concatenate resource: " + resource));
            if (resource == null || this.assembler == null) continue;
            this.assembler.assembly(resource);
        }
    }

    private URL getResourceURL(String resourceName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL resource = classLoader.getResource(resourceName);
        try {
            if (resource == null) {
                Class<?> clazz = classLoader.loadClass(resourceName);
                Object obj = clazz.newInstance();
                Method method = clazz.getMethod("getPath", new Class[0]);
                String path = (String)method.invoke(obj, new Object[0]);
                resource = classLoader.getResource(path);
            }
        }
        catch (Exception e) {
            this.log.error((CharSequence)("Error process: " + resourceName + "\n" + e.getMessage()), (Throwable)e);
        }
        return resource;
    }

    public void writeToFile() {
        if (this.assemblyFile != null) {
            if (this.assemblyFile.exists()) {
                this.assemblyFile.delete();
            }
            try {
                this.assemblyFile.createNewFile();
            }
            catch (IOException e) {
                this.log.error((CharSequence)("Error create assembly File: " + this.assemblyFile.getPath()), (Throwable)e);
            }
            this.assembler.writeToFile(this.assemblyFile);
        }
    }

    public File getAssemblyFile() {
        return this.assemblyFile;
    }

    public void setAssemblyFile(File assemblyFile) {
        this.assemblyFile = assemblyFile;
    }

    public Collection<String> getResources() {
        return this.resources;
    }

    public void setResources(Collection<String> resources) {
        this.resources = resources;
    }

    public List<String> getIncludesBefore() {
        return this.includesBefore;
    }

    public void setIncludesBefore(List<String> includesBefore) {
        this.includesBefore = includesBefore;
    }

    public List<String> getIncludesAfter() {
        return this.includesAfter;
    }

    public void setIncludesAfter(List<String> includesAfter) {
        this.includesAfter = includesAfter;
    }

    public ResourceAssembler getAssembler() {
        return this.assembler;
    }

    public void setAssembler(ResourceAssembler assembler) {
        this.assembler = assembler;
    }
}

