/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.rd.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import org.ajax4jsf.builder.config.ParsingException;
import org.ajax4jsf.builder.xml.XMLBody;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.richfaces.cdk.rd.generator.ResourceAssembler;

public class StyleAssembler
implements ResourceAssembler {
    private static final String PLAIN_CSS_BLOCK_START = "<f:verbatim><![CDATA[";
    private static final String PLAIN_CSS_BLOCK_END = "]]></f:verbatim>";
    protected Log log = new SystemStreamLog();
    private VelocityComponent velocityComponent;
    private StringBuilder builder = new StringBuilder();

    public StyleAssembler(Log log) {
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assembly(URL resource) {
        String file = resource.getFile();
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("process resource:  " + file));
        }
        try {
            InputStream resourceInputStream = resource.openStream();
            try {
                if (file.endsWith(".xcss")) {
                    XMLBody xmlBody = new XMLBody();
                    try {
                        xmlBody.loadXML(resourceInputStream, true);
                        this.builder.append(xmlBody.getContent());
                    }
                    catch (ParsingException e) {
                        this.log.error((CharSequence)("Error process xcss: " + e.getMessage()), (Throwable)e);
                    }
                } else {
                    this.builder.append(PLAIN_CSS_BLOCK_START);
                    this.builder.append(IOUtil.toString((InputStream)resourceInputStream));
                    this.builder.append(PLAIN_CSS_BLOCK_END);
                }
            }
            finally {
                resourceInputStream.close();
            }
        }
        catch (IOException e) {
            this.log.error((CharSequence)("Error process css file " + file + " : " + e.getMessage()), (Throwable)e);
        }
    }

    public VelocityComponent getVelocityComponent() {
        return this.velocityComponent;
    }

    public void setVelocityComponent(VelocityComponent velocityComponent) {
        this.velocityComponent = velocityComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File file) {
        block5: {
            try {
                if (this.builder.length() <= 0 || this.velocityComponent == null) break block5;
                VelocityContext context = new VelocityContext();
                context.put("content", (Object)this.builder);
                VelocityEngine engine = this.velocityComponent.getEngine();
                FileWriter fileWriter = new FileWriter(file);
                this.log.info((CharSequence)("write result to the: " + file.getPath()));
                try {
                    Template velocityTemplate = engine.getTemplate("templates12/xcss.vm");
                    velocityTemplate.merge((Context)context, (Writer)fileWriter);
                    fileWriter.flush();
                }
                finally {
                    fileWriter.close();
                }
            }
            catch (Exception e) {
                this.log.error((CharSequence)("Error write file: " + file.getAbsolutePath()), (Throwable)e);
            }
        }
    }
}

