/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.resource.writer.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.faces.application.Resource;
import org.richfaces.cdk.ResourceWriter;
import org.richfaces.cdk.resource.writer.ResourceProcessor;
import org.richfaces.cdk.resource.writer.impl.ThroughputResourceProcessor;
import org.richfaces.cdk.strings.Constants;

public class ResourceWriterImpl
implements ResourceWriter {
    private File resourceContentsDir;
    private File resourceMappingDir;
    private Map<String, String> processedResources = Maps.newConcurrentMap();
    private Iterable<ResourceProcessor> resourceProcessors;

    public ResourceWriterImpl(File resourceContentsDir, File resourceMappingDir, Iterable<ResourceProcessor> resourceProcessors) {
        this.resourceContentsDir = resourceContentsDir;
        this.resourceMappingDir = resourceMappingDir;
        this.resourceProcessors = Iterables.concat(resourceProcessors, Collections.singleton(ThroughputResourceProcessor.INSTANCE));
        resourceContentsDir.mkdirs();
    }

    private String getResourceQualifier(Resource resource) {
        return Constants.COLON_JOINER.join((Object)resource.getLibraryName(), (Object)resource.getResourceName(), new Object[0]);
    }

    private File createOutputFile(String path) throws IOException {
        File outFile = new File(this.resourceContentsDir, path);
        outFile.getParentFile().mkdirs();
        outFile.createNewFile();
        return outFile;
    }

    @Override
    public void writeResource(String skinName, Resource resource) throws IOException {
        String requestPath;
        String requestPathWithSkin = requestPath = resource.getRequestPath();
        if (requestPath.startsWith("%skin%/")) {
            requestPathWithSkin = Constants.SLASH_JOINER.join((Object)skinName, (Object)requestPath.substring("%skin%/".length()), new Object[0]);
        }
        for (ResourceProcessor resourceProcessor : this.resourceProcessors) {
            if (!resourceProcessor.isSupportedFile(requestPath)) continue;
            File outFile = this.createOutputFile(requestPathWithSkin);
            resourceProcessor.process(requestPathWithSkin, resource.getInputStream(), new FileOutputStream(outFile));
            this.processedResources.put(this.getResourceQualifier(resource), requestPath);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeProcessedResourceMappings() throws IOException {
        FileOutputStream fos = null;
        try {
            File mappingsFile = new File(this.resourceMappingDir, "META-INF/richfaces/static-resource-mappings.properties");
            mappingsFile.delete();
            mappingsFile.getParentFile().mkdirs();
            mappingsFile.createNewFile();
            fos = new FileOutputStream(mappingsFile);
            Properties properties = new Properties();
            properties.putAll(this.processedResources);
            properties.store(fos, null);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

