/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.resource.writer.impl;

import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.richfaces.cdk.resource.writer.ResourceProcessor;

public class CSSResourceProcessor
implements ResourceProcessor {
    private Charset charset;

    public CSSResourceProcessor(Charset charset) {
        this.charset = charset;
    }

    @Override
    public boolean isSupportedFile(String name) {
        return name.endsWith(".css");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String resourceName, InputSupplier<? extends InputStream> in, OutputSupplier<? extends OutputStream> out) throws IOException {
        InputStreamReader reader = null;
        OutputStreamWriter writer = null;
        try {
            reader = new InputStreamReader((InputStream)in.getInput(), this.charset);
            writer = new OutputStreamWriter((OutputStream)out.getOutput(), this.charset);
            new CssCompressor((Reader)reader).compress((Writer)writer, 0);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(reader);
            Closeables.closeQuietly(writer);
            throw throwable;
        }
        Closeables.closeQuietly((Closeable)reader);
        Closeables.closeQuietly((Closeable)writer);
    }
}

