/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.resource.scan.impl.reflections;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.util.Utils;
import org.richfaces.cdk.resource.scan.impl.reflections.MarkerResourcesScanner;

public class ReflectionsExt
extends Reflections {
    private static final Function<String, Class<?>> CLASS_FOR_NAME = new Function<String, Class<?>>(){

        public Class<?> apply(String from) {
            try {
                return Class.forName(from, true, Utils.getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (LinkageError e) {
                e.printStackTrace();
            }
            return null;
        }
    };

    public ReflectionsExt() {
    }

    public ReflectionsExt(Configuration configuration) {
        super(configuration);
    }

    public ReflectionsExt(String prefix, Scanner ... scanners) {
        super(prefix, scanners);
    }

    public Collection<Class<?>> getMarkedClasses() {
        Map storeMap = this.getStore().getStoreMap();
        Multimap scannerMMap = (Multimap)storeMap.get(MarkerResourcesScanner.class.getName());
        if (scannerMMap == null) {
            return Collections.emptySet();
        }
        return Collections2.filter((Collection)Collections2.transform((Collection)scannerMMap.get((Object)"org.richfaces.cdk.dynamicResourceNames"), CLASS_FOR_NAME), (Predicate)Predicates.notNull());
    }
}

