/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.richfaces.application.ServiceTracker;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.ResourceLibrary;
import org.richfaces.resource.ResourceLibraryFactory;

public class ResourceLibraryExpander {
    public Collection<ResourceKey> expandResourceLibraries(Collection<ResourceKey> resources) {
        ResourceLibraryFactory factory = (ResourceLibraryFactory)ServiceTracker.getService(ResourceLibraryFactory.class);
        LinkedHashSet expandedResources = Sets.newLinkedHashSet();
        for (ResourceKey resourceKey : resources) {
            if (resourceKey.getResourceName().endsWith(".reslib")) {
                String libraryName = resourceKey.getLibraryName();
                String resourceName = resourceKey.getResourceName().substring(0, resourceKey.getResourceName().length() - ".reslib".length());
                ResourceLibrary resourceLibrary = factory.getResourceLibrary(resourceName, libraryName);
                if (resourceLibrary == null) {
                    throw new IllegalArgumentException("Resource library is null: " + libraryName + ":" + resourceName);
                }
                for (ResourceKey expandedKey : resourceLibrary.getResources()) {
                    expandedResources.add(expandedKey);
                }
                continue;
            }
            expandedResources.add(resourceKey);
        }
        return expandedResources;
    }
}

