/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.task;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import org.apache.maven.plugin.logging.Log;
import org.richfaces.cdk.Faces;
import org.richfaces.cdk.ResourceTaskFactory;
import org.richfaces.cdk.ResourceWriter;
import org.richfaces.cdk.faces.CurrentResourceContext;
import org.richfaces.cdk.resource.util.ResourceConstants;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.ResourceSkinUtils;

public class ResourceTaskFactoryImpl
implements ResourceTaskFactory {
    private Log log;
    private Faces faces;
    private ResourceWriter resourceWriter;
    private CompletionService<Object> completionService;
    private String[] skins = new String[0];
    private Predicate<Resource> filter = Predicates.alwaysTrue();
    private boolean pack;

    public ResourceTaskFactoryImpl(Faces faces, boolean pack) {
        this.faces = faces;
        this.pack = pack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsELExpression(Resource resource) {
        InputStream is = null;
        try {
            is = resource.getInputStream();
            byte[] bs = ByteStreams.toByteArray((InputStream)is);
            for (int i = 0; i < bs.length; ++i) {
                byte b = bs[i];
                if (b != 35 || i + 1 >= bs.length || bs[i + 1] != 123) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            this.log.error((CharSequence)e.getMessage(), (Throwable)e);
        }
        finally {
            Closeables.closeQuietly((Closeable)is);
        }
        return false;
    }

    private boolean shouldCheckForEL(Resource resource) {
        String resourceName = resource.getResourceName();
        return resourceName.endsWith(".js") || resourceName.endsWith(".css");
    }

    public void setLog(Log log) {
        this.log = log;
    }

    @Override
    public void setResourceWriter(ResourceWriter resourceWriter) {
        this.resourceWriter = resourceWriter;
    }

    @Override
    public void setSkins(String[] skins) {
        this.skins = skins;
    }

    @Override
    public void setCompletionService(CompletionService<Object> completionService) {
        this.completionService = completionService;
    }

    @Override
    public void setFilter(Predicate<Resource> filter) {
        this.filter = filter;
    }

    @Override
    public void submit(Iterable<ResourceKey> locators) {
        for (ResourceKey locator : locators) {
            this.completionService.submit(new ResourcesRendererCallable(locator));
        }
    }

    private class ResourcesRendererCallable
    implements Callable<Object> {
        private ResourceKey resourceKey;
        private boolean skinDependent;
        private boolean skipped = false;

        ResourcesRendererCallable(ResourceKey resourceKey) {
            this.resourceKey = resourceKey;
            if (ResourceTaskFactoryImpl.this.pack && ResourceConstants.JSF_COMPRESSED.equals((Object)resourceKey)) {
                this.resourceKey = ResourceConstants.JSF_UNCOMPRESSED;
            }
        }

        private Resource createResource(FacesContext facesContext, ResourceKey resourceInfo) {
            ResourceHandler resourceHandler = facesContext.getApplication().getResourceHandler();
            return resourceHandler.createResource(resourceInfo.getResourceName(), resourceInfo.getLibraryName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void renderResource(String skin) {
            ResourceTaskFactoryImpl.this.log.debug((CharSequence)("rendering " + this.resourceKey + " (" + skin + ")"));
            try {
                FacesContext facesContext = ResourceTaskFactoryImpl.this.faces.startRequest();
                if (skin != null) {
                    ResourceTaskFactoryImpl.this.faces.setSkin(skin);
                }
                Resource resource = this.createResource(facesContext, this.resourceKey);
                CurrentResourceContext.getInstance(facesContext).setResource(resource);
                if (ResourceTaskFactoryImpl.this.shouldCheckForEL(resource) && ResourceTaskFactoryImpl.this.containsELExpression(resource)) {
                    ResourceTaskFactoryImpl.this.log.info((CharSequence)MessageFormat.format("Skipping {0} because it contains EL-expressions", this.resourceKey));
                    return;
                }
                if (ResourceTaskFactoryImpl.this.pack) {
                    ResourceTaskFactoryImpl.this.resourceWriter.writePackedResource(skin, resource);
                } else {
                    ResourceTaskFactoryImpl.this.resourceWriter.writeResource(skin, resource);
                }
                ResourceTaskFactoryImpl.this.log.debug((CharSequence)("rendered " + this.resourceKey + " (" + skin + ")"));
            }
            catch (Exception e) {
                ResourceTaskFactoryImpl.this.log.debug((CharSequence)("not rendered " + this.resourceKey + " (" + skin + ") - cought exception"));
                if (skin != null) {
                    ResourceTaskFactoryImpl.this.log.error((CharSequence)MessageFormat.format("Exception rendering resorce {0} using skin {1}: {2}", this.resourceKey, skin, e.getMessage()), (Throwable)e);
                } else {
                    ResourceTaskFactoryImpl.this.log.error((CharSequence)MessageFormat.format("Exception rendering resorce {0}: {1}", this.resourceKey, e.getMessage()), (Throwable)e);
                }
            }
            finally {
                ResourceTaskFactoryImpl.this.faces.setSkin(null);
                ResourceTaskFactoryImpl.this.faces.stopRequest();
            }
        }

        private void checkResource() {
            ResourceTaskFactoryImpl.this.log.debug((CharSequence)("checking " + this.resourceKey));
            try {
                FacesContext facesContext = ResourceTaskFactoryImpl.this.faces.startRequest();
                ResourceTaskFactoryImpl.this.faces.setSkin("DEFAULT");
                Resource resource = this.createResource(facesContext, this.resourceKey);
                if (resource == null) {
                    this.skipped = true;
                    return;
                }
                if (!ResourceTaskFactoryImpl.this.filter.apply((Object)resource)) {
                    this.skipped = true;
                    return;
                }
                String contentType = resource.getContentType();
                if (contentType == null) {
                    this.skipped = true;
                    return;
                }
                this.skinDependent = ResourceSkinUtils.isSkinDependent((String)resource.getRequestPath());
            }
            catch (Exception e) {
                throw (RuntimeException)e;
            }
            finally {
                ResourceTaskFactoryImpl.this.log.debug((CharSequence)("checked " + this.resourceKey + ": skinDependent: " + this.skinDependent + ", skipped: " + this.skipped));
                ResourceTaskFactoryImpl.this.faces.setSkin(null);
                ResourceTaskFactoryImpl.this.faces.stopRequest();
            }
        }

        @Override
        public Object call() throws Exception {
            this.checkResource();
            if (this.skipped) {
                ResourceTaskFactoryImpl.this.log.info((CharSequence)("Skipped resource rendering: " + this.resourceKey));
            } else if (this.skinDependent) {
                for (String skin : ResourceTaskFactoryImpl.this.skins) {
                    this.renderResource(skin);
                }
            } else {
                this.renderResource(null);
            }
            return null;
        }
    }
}

