/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.demo.iteration;

import com.google.common.collect.Iterators;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;

public class LazyTreeNode
implements TreeNode,
Serializable {
    private static final long serialVersionUID = 7222747310505408841L;
    private TreeNode srcNode;
    private LazyTreeNode parentNode;
    private List<LazyTreeNode> children = null;

    public LazyTreeNode(LazyTreeNode parentNode, TreeNode srcNode) {
        this.parentNode = parentNode;
        this.srcNode = srcNode;
    }

    public LazyTreeNode(TreeNode srcNode) {
        this(null, srcNode);
    }

    private void initializeChildren() {
        if (this.children != null) {
            return;
        }
        this.children = new ArrayList();
        Enumeration<? extends TreeNode> srcChildren = this.srcNode.children();
        while (srcChildren.hasMoreElements()) {
            TreeNode srcChild = srcChildren.nextElement();
            this.children.add(new LazyTreeNode(this, srcChild));
        }
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        this.initializeChildren();
        return (TreeNode)this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        this.initializeChildren();
        return this.children.size();
    }

    @Override
    public TreeNode getParent() {
        return this.parentNode;
    }

    @Override
    public int getIndex(TreeNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public Enumeration children() {
        this.initializeChildren();
        return Iterators.asEnumeration(this.children.iterator());
    }

    public TreeNode getWrappedNode() {
        return this.srcNode;
    }
}

