/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.demo.validator;

import java.util.ArrayList;
import java.util.List;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import org.richfaces.demo.validator.MaxBean;
import org.richfaces.demo.validator.MinBean;
import org.richfaces.demo.validator.MinMaxBean;
import org.richfaces.demo.validator.NotEmptyBean;
import org.richfaces.demo.validator.NotNullBean;
import org.richfaces.demo.validator.PatternBean;
import org.richfaces.demo.validator.SizeBean;
import org.richfaces.demo.validator.Validable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedBean
@SessionScoped
public class ValidatorBean {
    private final List<Validable<?>> beans = new ArrayList(7);

    @Valid
    public List<Validable<?>> getBeans() {
        return this.beans;
    }

    public ValidatorBean() {
        this.beans.add(new NotNullBean());
        this.beans.add(new NotEmptyBean());
        this.beans.add(new SizeBean());
        this.beans.add(new MinBean());
        this.beans.add(new MaxBean());
        this.beans.add(new MinMaxBean());
        this.beans.add(new PatternBean());
    }

    @Max(value=20L, message="Total value should be less then 20")
    public int getTotal() {
        int total = 0;
        for (Validable bean : this.beans) {
            Object value = bean.getValue();
            if (!(value instanceof Integer)) continue;
            Integer intValue = (Integer)value;
            total += intValue.intValue();
        }
        return total;
    }
}

