/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.demo.input.autocomplete;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.SessionScoped;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.richfaces.demo.input.CountriesBean;
import org.richfaces.demo.input.autocomplete.AutoCompleteBean;
import org.richfaces.ui.input.autocomplete.AutocompleteMode;

@ManagedBean
@SessionScoped
public class AutoCompleteBean
implements Serializable {
    private static final long serialVersionUID = 3072125097847582809L;
    private Object value;
    private AutocompleteMode mode = AutocompleteMode.lazyClient;
    @ManagedProperty(value="#{countriesBean}")
    private CountriesBean countriesBean;

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public AutocompleteMode getMode() {
        return this.mode;
    }

    public void setMode(AutocompleteMode mode) {
        this.mode = mode;
    }

    public void setCountriesBean(CountriesBean countriesBean) {
        this.countriesBean = countriesBean;
    }

    public Object autocomplete(FacesContext facesContext, UIComponent component, String value) {
        AutocompleteMode mode = (AutocompleteMode)component.getAttributes().get("mode");
        boolean isClient = mode == AutocompleteMode.client || mode == AutocompleteMode.lazyClient;
        String v = isClient || value == null ? "" : value;
        return Collections2.filter((Collection)this.countriesBean.getCountries(), (Predicate)new CountryNamePredicate(this, v.toLowerCase(Locale.US)));
    }

    public Object getModes() {
        return AutocompleteMode.values();
    }
}

