/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.demo.iteration;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import javax.swing.tree.TreeNode;
import org.richfaces.model.SwingTreeNodeImpl;
import org.richfaces.util.FastJoiner;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TreeNodeParser
implements ContentHandler {
    private static final FastJoiner JOINER = FastJoiner.on((String)"");
    private XMLReader reader;
    private List<TreeNode> rootNodes = Lists.newArrayList();
    private SwingTreeNodeImpl<String> currentNode;

    public TreeNodeParser() throws SAXException {
        this.reader = XMLReaderFactory.createXMLReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(URL url) throws IOException, SAXException {
        InputStream is = null;
        try {
            is = url.openStream();
            this.reader.setContentHandler((ContentHandler)this);
            this.reader.parse(new InputSource(is));
        }
        finally {
            Closeables.closeQuietly((Closeable)is);
        }
    }

    public List<TreeNode> getRootNodes() {
        return this.rootNodes;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        SwingTreeNodeImpl newNode = new SwingTreeNodeImpl();
        if (this.currentNode == null) {
            this.rootNodes.add(newNode);
        } else {
            this.currentNode.addChild((TreeNode)newNode);
        }
        newNode.setData((Object)JOINER.join(new String[]{(String)newNode.getData(), localName.toLowerCase(Locale.US), " ["}));
        this.currentNode = newNode;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.currentNode.setData((Object)JOINER.join((String)this.currentNode.getData(), "]"));
        this.currentNode = (SwingTreeNodeImpl)this.currentNode.getParent();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentNode.setData((Object)JOINER.join((String)this.currentNode.getData(), new String(ch, start, length).trim()));
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }
}

